/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.Token;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractErrorEntity;
import java.util.Objects;

class SemanticErrorEntity
extends AbstractErrorEntity {
    public SemanticErrorEntity(String sql, Token start, Token stop, String msg) {
        super(SemanticErrorEntity.constructFormattedErrorMessage(sql, start, stop, msg));
    }

    static String constructFormattedErrorMessage(String sql, Token start, Token stop, String msg) {
        Objects.requireNonNull(sql, TWCMessageUtil.getMessage("0007", "sql"));
        Objects.requireNonNull(sql, TWCMessageUtil.getMessage("0007", "start"));
        Objects.requireNonNull(sql, TWCMessageUtil.getMessage("0007", "stop"));
        StringBuilder sb = new StringBuilder().append("line ").append(start.getLine()).append(":").append(start.getStartIndex()).append(" to ").append(stop.getLine()).append(":").append(stop.getStopIndex()).append(" ").append(msg).append(System.lineSeparator());
        String[] lines = sql.split("\\r?\\n");
        for (int i = start.getLine(); i <= stop.getLine(); ++i) {
            int j;
            int startIdx;
            String currentLine = lines[i - 1];
            sb.append(currentLine);
            sb.append(System.lineSeparator());
            if (i == start.getLine() && i == stop.getLine()) {
                int j2;
                startIdx = start.getStartIndex();
                int stopIdx = stop.getStopIndex();
                for (j2 = 0; j2 < startIdx; ++j2) {
                    sb.append(" ");
                }
                for (j2 = startIdx; j2 <= stopIdx; ++j2) {
                    sb.append("^");
                }
            } else if (i == start.getLine()) {
                startIdx = start.getStartIndex();
                for (j = 0; j < startIdx; ++j) {
                    sb.append(" ");
                }
                for (j = startIdx; j < currentLine.length(); ++j) {
                    sb.append("^");
                }
            } else if (i == stop.getLine()) {
                int stopIdx = stop.getStopIndex();
                for (j = 0; j <= stopIdx; ++j) {
                    sb.append("^");
                }
            } else {
                for (int j3 = 0; j3 < currentLine.length(); ++j3) {
                    sb.append("^");
                }
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

