/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import com.ibm.cognos.jdbc.twc.util.MetadataUtils;

class StringLiteralValue
extends AbstractLiteralValue {
    private StringLiteralValue(String literal, ParseTree ctx) {
        super(literal, Column.Datatype.VARCHAR, ctx);
    }

    @Override
    public String getTypeName() {
        return MetadataUtils.inferDatatypeName(this.getDataType(), this.getLiteralValue().length(), 0, this.getLiteralValue().length());
    }

    @Override
    public boolean isEquivalent(Entity literal) {
        if (literal instanceof StringLiteralValue) {
            return this.getLiteralValue().compareTo(((StringLiteralValue)literal).getLiteralValue()) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(LiteralValue o) {
        if (o instanceof StringLiteralValue) {
            StringLiteralValue value = (StringLiteralValue)o;
            String v1 = this.getLiteralValue();
            String v2 = value.getLiteralValue();
            return v1.compareTo(v2);
        }
        throw new IllegalArgumentException("Provided argument is not of type 'StringLiteralValue'.");
    }

    @Override
    public String toString() {
        return SINGLE_QUOTE_STR + this.getLiteralValue() + SINGLE_QUOTE_STR;
    }

    static class Builder {
        private String aLiteralValue;
        private ParseTree aCtx;

        Builder() {
        }

        Builder setLiteralValue(String literal) {
            this.aLiteralValue = literal;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        StringLiteralValue build() {
            return new StringLiteralValue(this.aLiteralValue, this.aCtx);
        }
    }
}

