/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Catalog;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.ANTLRInputStream;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.CommonTokenStream;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedTable;
import com.ibm.cognos.jdbc.twc.sqlparser.ErrorEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserListenerImpl;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLLexer;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLParser;
import java.net.URI;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class TWCSQLParserWrapper
implements TWCMessageKeys {
    private final AtomicBoolean queryParsed;
    private final TWCSQLParser parser;
    private final TWCSQLParserListenerImpl listener;

    public TWCSQLParserWrapper(String id, String sql, Server metadata, String defaultCatalog, String defaultSchema, String defaultLanguage, String defaultUnits, URI baseURI, boolean strictMode) {
        this.listener = new TWCSQLParserListenerImpl(id, sql, metadata, defaultCatalog, defaultSchema, defaultLanguage, defaultUnits, baseURI, strictMode);
        ANTLRInputStream in = new ANTLRInputStream(sql);
        TWCSQLLexer lexer = new TWCSQLLexer(in);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        this.parser = new TWCSQLParser(tokens);
        this.parser.addParseListener(this.listener);
        this.parser.removeErrorListeners();
        this.parser.addErrorListener(this.listener);
        lexer.removeErrorListeners();
        lexer.addErrorListener(this.listener);
        this.queryParsed = new AtomicBoolean();
    }

    public String getSQLQuery() {
        return this.listener.getSQL();
    }

    public boolean isValid() {
        this.checkQueryParsed();
        return this.listener.getErrors().isEmpty();
    }

    public List<String> getURIs() {
        this.checkQueryParsed();
        return this.listener.getURIs();
    }

    public Catalog getCatalog() {
        this.checkQueryParsed();
        return this.listener.getCatalog();
    }

    public Schema getSchema() {
        this.checkQueryParsed();
        return this.listener.getSchema();
    }

    public List<BoundedColumn> getBoundedColumns() {
        this.checkQueryParsed();
        return this.listener.getBoundedColumns();
    }

    public Object[] getProjectedLiterals() {
        this.checkQueryParsed();
        return this.listener.getProjectedLiterals();
    }

    public int[] getProjectedLiteralsOrdinalPositions() {
        this.checkQueryParsed();
        return this.listener.getProjectedLiteralsOrdinalPositions();
    }

    public Map<String, BoundedTable> getBoundedTables() {
        this.checkQueryParsed();
        return this.listener.getBoundedTables();
    }

    public List<String> getCommonColumns() {
        this.checkQueryParsed();
        return this.listener.getCommonColumns();
    }

    public Map<String, String> getTreatColumnsAs() {
        this.checkQueryParsed();
        return this.listener.getTreatColumnsAs();
    }

    public List<String> getIgnoredFilterIdentifiers() {
        this.checkQueryParsed();
        return this.listener.getIgnoredFilterIdentifiers();
    }

    public boolean evaluateFilterExpression(FilterConditionEvaluator evaluator) {
        this.checkQueryParsed();
        return this.listener.evaluateFilterExpression(evaluator);
    }

    public List<String> getPostalCodes() {
        this.checkQueryParsed();
        return this.listener.getPostalCodes();
    }

    public List<LocalDate> getDateValues() {
        this.checkQueryParsed();
        return this.listener.getDateValues();
    }

    public void parse() throws SQLException {
        if (!this.queryParsed.compareAndSet(false, true)) {
            throw new IllegalStateException(TWCMessageUtil.getMessage("0071"));
        }
        this.parser.cte();
        if (!this.listener.getErrors().isEmpty()) {
            String msg = this.listener.getErrors().stream().map(ErrorEntity::getFormattedErrorMessage).collect(Collectors.joining(System.lineSeparator(), TWCMessageUtil.getMessage("0072") + System.lineSeparator(), ""));
            throw new SQLSyntaxErrorException(msg);
        }
    }

    private void checkQueryParsed() {
        if (!this.queryParsed.get()) {
            throw new IllegalStateException(TWCMessageUtil.getMessage("0070"));
        }
    }
}

