/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import java.util.Objects;

class TableIdentifierEntity
extends AbstractIdentifierEntity
implements TWCMessageKeys {
    private String catalog;
    private String schema;
    private String tableName;
    private String tableAlias;

    private TableIdentifierEntity(String catalogValue, String schemaValue, String tableValue, String aliasValue, ParseTree ctx) {
        super(ctx);
        Objects.requireNonNull(catalogValue, TWCMessageUtil.getMessage("0007", "catalogValue"));
        Objects.requireNonNull(schemaValue, TWCMessageUtil.getMessage("0007", "schemaValue"));
        Objects.requireNonNull(tableValue, TWCMessageUtil.getMessage("0007", "tableValue"));
        Objects.requireNonNull(aliasValue, TWCMessageUtil.getMessage("0007", "aliasValue"));
        if (tableValue.isEmpty()) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0008", "tableValue"));
        }
        this.catalog = catalogValue;
        this.schema = schemaValue;
        this.tableName = tableValue;
        this.tableAlias = aliasValue;
    }

    String getCatalog() {
        return this.catalog;
    }

    String getSchema() {
        return this.schema;
    }

    String getTable() {
        return this.tableName;
    }

    String getAlias() {
        return this.tableAlias;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof TableIdentifierEntity) {
            TableIdentifierEntity tableEntity = (TableIdentifierEntity)entity;
            return this.catalog.compareTo(tableEntity.getCatalog()) == 0 && this.schema.compareTo(tableEntity.getSchema()) == 0 && this.tableName.compareTo(tableEntity.getTable()) == 0 && this.tableAlias.compareTo(tableEntity.getAlias()) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.catalog.isEmpty()) {
            sb.append(DOUBLE_QUOTE_STR).append(this.catalog).append(DOUBLE_QUOTE_STR).append(DOT_STR);
        }
        if (!this.schema.isEmpty()) {
            sb.append(DOUBLE_QUOTE_STR).append(this.schema).append(DOUBLE_QUOTE_STR).append(DOT_STR);
        }
        sb.append(DOUBLE_QUOTE_STR).append(this.tableName).append(DOUBLE_QUOTE_STR);
        if (!this.tableAlias.isEmpty()) {
            sb.append(" ").append(DOUBLE_QUOTE_STR).append(this.tableAlias).append(DOUBLE_QUOTE_STR);
        }
        return sb.toString();
    }

    static class Builder {
        private String aCatalog = "";
        private String aSchema = "";
        private String aTableName = "";
        private String aTableAlias = "";
        private ParseTree aCtx;

        Builder() {
        }

        Builder setCatalog(String v) {
            this.aCatalog = v;
            return this;
        }

        Builder setSchema(String v) {
            this.aSchema = v;
            return this;
        }

        Builder setTableName(String v) {
            this.aTableName = v;
            return this;
        }

        Builder setTableAlias(String v) {
            this.aTableAlias = v;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        TableIdentifierEntity build() {
            return new TableIdentifierEntity(this.aCatalog, this.aSchema, this.aTableName, this.aTableAlias, this.aCtx);
        }
    }
}

