/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.univocity.parsers.csv;

import com.ibm.cognos.jdbc.twc.univocity.parsers.common.input.InputAnalysisProcess;
import com.ibm.cognos.jdbc.twc.univocity.parsers.csv.CsvFormat;
import com.ibm.cognos.jdbc.twc.univocity.parsers.csv.CsvParserSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

abstract class CsvFormatDetector
implements InputAnalysisProcess {
    private final int MAX_ROW_SAMPLES;
    private final char comment;
    private final char suggestedDelimiter;
    private final char normalizedNewLine;

    CsvFormatDetector(int maxRowSamples, CsvParserSettings settings) {
        this.MAX_ROW_SAMPLES = maxRowSamples;
        this.suggestedDelimiter = ((CsvFormat)settings.getFormat()).getDelimiter();
        this.normalizedNewLine = ((CsvFormat)settings.getFormat()).getNormalizedNewline();
        this.comment = ((CsvFormat)settings.getFormat()).getComment();
    }

    @Override
    public void execute(char[] characters, int length) {
        int i;
        HashSet<Character> allSymbols = new HashSet<Character>();
        HashMap<Character, Integer> symbols = new HashMap<Character, Integer>();
        HashMap<Character, Integer> escape = new HashMap<Character, Integer>();
        ArrayList<HashMap<Character, Integer>> symbolsPerRow = new ArrayList<HashMap<Character, Integer>>();
        int doubleQuoteCount = 0;
        int singleQuoteCount = 0;
        char inQuote = '\u0000';
        boolean afterNewLine = true;
        for (i = 0; i < length; ++i) {
            char ch = characters[i];
            if (afterNewLine && ch == this.comment) {
                while (++i < length && (ch = characters[i]) != '\r' && ch != '\n' && ch != this.normalizedNewLine) {
                }
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                if (inQuote == ch) {
                    char prev;
                    char next;
                    if (ch == '\"') {
                        ++doubleQuoteCount;
                    } else {
                        ++singleQuoteCount;
                    }
                    if (i + 1 < length && (Character.isLetterOrDigit(next = characters[i + 1]) || next <= ' ') && !Character.isLetterOrDigit(prev = characters[i - 1])) {
                        CsvFormatDetector.increment(escape, prev);
                    }
                    inQuote = '\u0000';
                    continue;
                }
                inQuote = ch;
                continue;
            }
            if (inQuote != '\u0000') continue;
            afterNewLine = false;
            if (!(Character.isLetterOrDigit(ch) || ch != '\t' && ch <= ' ')) {
                allSymbols.add(Character.valueOf(ch));
                CsvFormatDetector.increment(symbols, ch);
                continue;
            }
            if (ch != '\r' && ch != '\n' && ch != this.normalizedNewLine || symbols.size() <= 0) continue;
            afterNewLine = true;
            symbolsPerRow.add(symbols);
            if (symbolsPerRow.size() == this.MAX_ROW_SAMPLES) break;
            symbols = new HashMap();
        }
        if (i >= length && symbolsPerRow.size() > 1) {
            symbolsPerRow.remove(symbolsPerRow.size() - 1);
        }
        HashMap<Character, Integer> sums = new HashMap<Character, Integer>();
        HashSet<Character> toRemove = new HashSet<Character>();
        for (Map map : symbolsPerRow) {
            for (Map map2 : symbolsPerRow) {
                for (Character symbol : allSymbols) {
                    Integer previousCount = (Integer)map.get(symbol);
                    Integer currentCount = (Integer)map2.get(symbol);
                    if (previousCount == null && currentCount == null) {
                        toRemove.add(symbol);
                    }
                    if (previousCount == null || currentCount == null) continue;
                    CsvFormatDetector.increment(sums, symbol.charValue(), Math.abs(previousCount - currentCount));
                }
            }
        }
        sums.keySet().removeAll(toRemove);
        char delimiter = CsvFormatDetector.min(sums, this.suggestedDelimiter);
        char c = doubleQuoteCount >= singleQuoteCount ? (char)'\"' : '\'';
        escape.remove(Character.valueOf(delimiter));
        char quoteEscape = CsvFormatDetector.max(escape, c);
        this.apply(delimiter, c, quoteEscape);
    }

    private static void increment(Map<Character, Integer> map, char symbol) {
        CsvFormatDetector.increment(map, symbol, 1);
    }

    private static void increment(Map<Character, Integer> map, char symbol, int incrementSize) {
        Integer count = map.get(Character.valueOf(symbol));
        if (count == null) {
            count = 0;
        }
        map.put(Character.valueOf(symbol), count + incrementSize);
    }

    private static char min(Map<Character, Integer> map, char defaultChar) {
        return CsvFormatDetector.getChar(map, defaultChar, true);
    }

    private static char max(Map<Character, Integer> map, char defaultChar) {
        return CsvFormatDetector.getChar(map, defaultChar, false);
    }

    private static char getChar(Map<Character, Integer> map, char defaultChar, boolean min) {
        int val = min ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (Map.Entry<Character, Integer> e : map.entrySet()) {
            int sum = e.getValue();
            if ((!min || sum >= val) && (min || sum <= val)) continue;
            val = sum;
            defaultChar = e.getKey().charValue();
        }
        return defaultChar;
    }

    abstract void apply(char var1, char var2, char var3);
}

