/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.univocity.parsers.fixed;

import com.ibm.cognos.jdbc.twc.univocity.parsers.common.CommonWriterSettings;
import com.ibm.cognos.jdbc.twc.univocity.parsers.fixed.FieldAlignment;
import com.ibm.cognos.jdbc.twc.univocity.parsers.fixed.FixedWidthFields;
import com.ibm.cognos.jdbc.twc.univocity.parsers.fixed.FixedWidthFormat;
import com.ibm.cognos.jdbc.twc.univocity.parsers.fixed.Lookup;
import java.util.HashMap;
import java.util.Map;

public class FixedWidthWriterSettings
extends CommonWriterSettings<FixedWidthFormat> {
    private FixedWidthFields fieldLengths;
    private final Map<String, FixedWidthFields> lookaheadFormats = new HashMap<String, FixedWidthFields>();
    private final Map<String, FixedWidthFields> lookbehindFormats = new HashMap<String, FixedWidthFields>();
    private boolean useDefaultPaddingForHeaders = true;
    private FieldAlignment defaultAlignmentForHeaders = null;
    private boolean writeLineSeparatorAfterRecord = true;

    public FixedWidthWriterSettings(FixedWidthFields fieldLengths) {
        this.setFieldLengths(fieldLengths);
        String[] names = fieldLengths.getFieldNames();
        if (names != null) {
            this.setHeaders(names);
        }
    }

    public FixedWidthWriterSettings() {
        this.fieldLengths = null;
    }

    final void setFieldLengths(FixedWidthFields fieldLengths) {
        if (fieldLengths == null) {
            throw new IllegalArgumentException("Field lengths cannot be null");
        }
        this.fieldLengths = fieldLengths;
    }

    int[] getFieldLengths() {
        if (this.fieldLengths == null) {
            return null;
        }
        return this.fieldLengths.getFieldLengths();
    }

    FieldAlignment[] getFieldAlignments() {
        if (this.fieldLengths == null) {
            return null;
        }
        return this.fieldLengths.getFieldAlignments();
    }

    char[] getFieldPaddings() {
        if (this.fieldLengths == null) {
            return null;
        }
        return this.fieldLengths.getFieldPaddings((FixedWidthFormat)this.getFormat());
    }

    @Override
    protected FixedWidthFormat createDefaultFormat() {
        return new FixedWidthFormat();
    }

    @Override
    public int getMaxColumns() {
        int minimum;
        int max = super.getMaxColumns();
        return max > (minimum = Lookup.calculateMaxFieldLengths(this.fieldLengths, this.lookaheadFormats, this.lookbehindFormats).length) ? max : minimum;
    }

    public void addFormatForLookahead(String lookahead, FixedWidthFields lengths) {
        Lookup.registerLookahead(lookahead, lengths, this.lookaheadFormats);
    }

    public void addFormatForLookbehind(String lookbehind, FixedWidthFields lengths) {
        Lookup.registerLookbehind(lookbehind, lengths, this.lookbehindFormats);
    }

    Lookup[] getLookaheadFormats() {
        return Lookup.getLookupFormats(this.lookaheadFormats, (FixedWidthFormat)this.getFormat());
    }

    Lookup[] getLookbehindFormats() {
        return Lookup.getLookupFormats(this.lookbehindFormats, (FixedWidthFormat)this.getFormat());
    }

    public boolean getUseDefaultPaddingForHeaders() {
        return this.useDefaultPaddingForHeaders;
    }

    public void setUseDefaultPaddingForHeaders(boolean useDefaultPaddingForHeaders) {
        this.useDefaultPaddingForHeaders = useDefaultPaddingForHeaders;
    }

    public FieldAlignment getDefaultAlignmentForHeaders() {
        return this.defaultAlignmentForHeaders;
    }

    public void setDefaultAlignmentForHeaders(FieldAlignment defaultAlignmentForHeaders) {
        this.defaultAlignmentForHeaders = defaultAlignmentForHeaders;
    }

    public boolean getWriteLineSeparatorAfterRecord() {
        return this.writeLineSeparatorAfterRecord;
    }

    public void setWriteLineSeparatorAfterRecord(boolean writeLineSeparatorAfterRecord) {
        this.writeLineSeparatorAfterRecord = writeLineSeparatorAfterRecord;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        out.put("Write line separator after record", this.writeLineSeparatorAfterRecord);
        out.put("Field lengths", this.fieldLengths);
        out.put("Lookahead formats", this.lookaheadFormats);
        out.put("Lookbehind formats", this.lookbehindFormats);
        out.put("Use default padding for headers", this.useDefaultPaddingForHeaders);
        out.put("Default alignment for headers", (Object)this.defaultAlignmentForHeaders);
    }
}

