/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbcinfo;

import com.ibm.cognos.jdbcinfo.App;

public abstract class Action
implements Comparable<Action> {
    private String name;
    protected int priority = 0;
    protected String[] parameters;
    protected int numParameters = 0;
    protected String usage = "";

    public String getName() {
        if (this.name == null) {
            this.name = this.getClass().getSimpleName().replace("Action", "");
        }
        return this.name;
    }

    public boolean isMatch(String aname) {
        return this.getName().equalsIgnoreCase(aname);
    }

    public int consumeArguments(int index, String[] arguments) throws Exception {
        if (this.numParameters > 0) {
            if (index + this.numParameters > arguments.length) {
                throw new Exception("Not enough argments for specified action " + this.getName());
            }
            this.parameters = new String[this.numParameters];
            for (int i = 0; i < this.numParameters; ++i) {
                this.parameters[i] = arguments[index + i];
            }
        }
        return index + this.numParameters;
    }

    public String getUsage() {
        return this.usage;
    }

    public int getPriority() {
        return this.priority;
    }

    protected String format(Object ... arguments) {
        StringBuffer text = new StringBuffer();
        boolean comma = false;
        for (Object arg : arguments) {
            if (!comma) {
                comma = true;
            } else {
                text.append(", ");
            }
            if (arg == null) {
                text.append("null");
                continue;
            }
            if (arg instanceof Object[]) {
                text.append("[" + this.format((Object[])arg) + "]");
                continue;
            }
            text.append(arg.toString());
        }
        return text.toString();
    }

    protected void mapNulls() {
        for (int i = 0; i < this.numParameters; ++i) {
            if (!"-NULL-".equalsIgnoreCase(this.parameters[i])) continue;
            this.parameters[i] = null;
        }
    }

    public boolean equals(Action a) {
        return a != null ? this.getName().equals(a.getName()) : false;
    }

    @Override
    public int compareTo(Action a) {
        return this.getName().compareTo(a.getName());
    }

    public abstract void go(App var1) throws Exception;
}

