/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbcinfo;

import com.ibm.bi.crypto.tunnel.tls.ClientTlsCredentials;
import com.ibm.bi.crypto.tunnel.utils.Certificates;
import com.ibm.cognos.jdbcinfo.Action;
import com.ibm.cognos.jdbcinfo.App;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class GenerateCertificateAction
extends Action {
    public GenerateCertificateAction() {
        this.numParameters = 2;
        this.usage = "<file name for server pem> <output files name>";
        this.priority = 20;
    }

    @Override
    public void go(App app) throws Exception {
        Throwable throwable;
        FileOutputStream fos;
        System.out.println("loading server certificate file from: " + this.parameters[0]);
        ClientTlsCredentials mutualAuthClientTlsCredentials = ClientTlsCredentials.newClientTlsCredentials();
        X509Certificate tunnelDestinationRootCertificate = Certificates.x509CertificateFromPem((InputStream)new FileInputStream(this.parameters[0]));
        mutualAuthClientTlsCredentials.addTrustedCertificate(tunnelDestinationRootCertificate);
        X509Certificate clientRootCa = mutualAuthClientTlsCredentials.certificateChain()[0];
        tunnelDestinationRootCertificate.checkValidity();
        byte[] clientRootCaAsBytes = Certificates.pemEncodedCertificateContent((Certificate)clientRootCa);
        File file = new File(this.parameters[1] + ".pem");
        if (file.createNewFile()) {
            try {
                fos = new FileOutputStream(file);
                throwable = null;
                try {
                    fos.write(clientRootCaAsBytes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println("File not found" + e);
            }
        }
        if ((file = new File(this.parameters[1] + ".bin")).createNewFile()) {
            try {
                fos = new FileOutputStream(file);
                throwable = null;
                try {
                    mutualAuthClientTlsCredentials.serialize((OutputStream)fos);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println("File not found" + e);
            }
        }
    }
}

