/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanException;
import javax.management.RuntimeMBeanException;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.remote.http.HTTPConnection;
import org.apache.axis.AxisFault;

class ClientExceptionCatcher
implements InvocationHandler {
    private final HTTPConnection target;

    public static HTTPConnection newInstance(HTTPConnection target) {
        ClientExceptionCatcher handler = new ClientExceptionCatcher(target);
        return (HTTPConnection)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{HTTPConnection.class}, (InvocationHandler)handler);
    }

    private ClientExceptionCatcher(HTTPConnection target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException x) {
                throw x.getTargetException();
            }
        }
        catch (Throwable x) {
            throw this.handleException(x, method.getExceptionTypes());
        }
    }

    private Throwable handleException(Throwable x, Class[] declared) {
        if (x instanceof Error) {
            return x;
        }
        if (x instanceof AxisFault) {
            x = this.extractThrowable((AxisFault)x);
        }
        if (this.isDeclaredOrRuntime(x, declared)) {
            return x;
        }
        return new IOException(x.toString());
    }

    private Throwable extractThrowable(AxisFault fault) {
        Exception exception;
        Logger logger;
        String message;
        String className;
        block17: {
            Logger logger2;
            Class<?> cls;
            block16: {
                block15: {
                    String name = fault.getFaultString();
                    if (name == null) {
                        return fault;
                    }
                    int colon = name.indexOf(58);
                    className = colon < 0 ? name : name.substring(0, colon).trim();
                    message = colon < 0 ? null : name.substring(colon + 1).trim();
                    cls = null;
                    try {
                        cls = this.getClass().getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException x) {
                        logger = this.getLogger();
                        if (!logger.isEnabledFor(0)) break block15;
                        logger.trace("Cannot load Throwable class " + className, x);
                    }
                }
                if (cls == null) {
                    return fault;
                }
                exception = null;
                if (message != null) {
                    try {
                        Constructor<?> ctor = cls.getConstructor(String.class);
                        exception = ctor.newInstance(message);
                    }
                    catch (Throwable x) {
                        logger2 = this.getLogger();
                        if (!logger2.isEnabledFor(0)) break block16;
                        logger2.trace("Cannot find constructor " + className + "(String message)", x);
                    }
                }
            }
            if (exception == null) {
                try {
                    exception = (Exception)cls.newInstance();
                }
                catch (Throwable x) {
                    logger2 = this.getLogger();
                    if (!logger2.isEnabledFor(0)) break block17;
                    logger2.trace("Cannot find constructor " + className + "()", x);
                }
            }
        }
        if (MBeanException.class.getName().equals(className)) {
            exception = new MBeanException(null, message);
        } else if (RuntimeMBeanException.class.getName().equals(className)) {
            exception = new RuntimeMBeanException(null, message);
        }
        if (!(exception instanceof Throwable)) {
            logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Could not recreate exception thrown on server side: " + className);
            }
            return fault;
        }
        return exception;
    }

    private boolean isDeclaredOrRuntime(Throwable x, Class[] declared) {
        if (x instanceof RuntimeException) {
            return true;
        }
        for (int i = 0; i < declared.length; ++i) {
            Class exception = declared[i];
            if (!exception.isInstance(x)) continue;
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }
}

