/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons;

import com.ibm.ba.gemini.commons.EmptyResourceBundle;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMessages {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ResourceMessages.class);
    private final ResourceBundle resourceBundle;
    private String resourceBundleName;

    public ResourceMessages(String resourceBundleFqn) {
        this.resourceBundle = this.getResourceBundle(resourceBundleFqn);
        this.resourceBundleName = resourceBundleFqn;
    }

    public String getMessage(String key, Object ... params) {
        return this.getMessageFromBundle(this.resourceBundle, key, params);
    }

    public String getMessage(List<Locale> locales, String key, Object ... params) {
        ResourceBundle bundle = this.mapLocaleToBundle(locales);
        return this.getMessageFromBundle(bundle, key, params);
    }

    private String getMessageFromBundle(ResourceBundle bundle, String key, Object ... params) {
        try {
            String res = bundle.getString(key);
            if (params != null && params.length > 0) {
                res = MessageFormat.format(res, params);
            }
            return res;
        }
        catch (MissingResourceException e) {
            LOGGER.debug("Missing message {}", (Object)key, (Object)e);
            return '!' + key + '!';
        }
    }

    private ResourceBundle getResourceBundle(String resourceBundleFqn) {
        try {
            return ResourceBundle.getBundle(resourceBundleFqn, Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            LOGGER.debug("Missing resource bundle {}", (Object)resourceBundleFqn, (Object)e);
            return this.getRootResourceBundle(resourceBundleFqn);
        }
    }

    private ResourceBundle getRootResourceBundle(String resourceBundleFqn) {
        try {
            return ResourceBundle.getBundle(resourceBundleFqn, Locale.ROOT, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return EmptyResourceBundle.INSTANCE;
        }
    }

    private ResourceBundle mapLocaleToBundle(List<Locale> locales) {
        ResourceBundle rootBundle = ResourceBundle.getBundle(this.resourceBundleName, new Locale("dummy"));
        for (Locale locale : locales) {
            ResourceBundle candBundle = ResourceBundle.getBundle(this.resourceBundleName, locale);
            if (!candBundle.equals(rootBundle)) {
                return candBundle;
            }
            if (!locale.getLanguage().equals(candBundle.getLocale())) continue;
            return candBundle;
        }
        return rootBundle;
    }
}

