/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.i18n.classloader;

import com.ibm.ba.gemini.commons.api.i18n.ResourceManager;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderResourceManager
implements ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderResourceManager.class);
    private final String resourceName;

    public ClassLoaderResourceManager(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getString(String resourceId, Locale locale) {
        String value = "";
        ResourceBundle serverResources = this.getServerResourceBundle(locale);
        if (serverResources != null) {
            value = this.getResourceValue(resourceId, serverResources);
        }
        return value;
    }

    private ResourceBundle getServerResourceBundle(Locale locale) {
        try {
            return PropertyResourceBundle.getBundle(this.resourceName, locale);
        }
        catch (MissingResourceException e) {
            LOGGER.debug("Missing locale '{}' for resource '{}'", (Object)locale, (Object)this.resourceName);
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getResourceValue(String resourceId, ResourceBundle resources) {
        try {
            return resources.getString(resourceId);
        }
        catch (MissingResourceException e) {
            LOGGER.debug("Missing resourceId '{}' for locale '{}' and resource '{}'", new Object[]{resourceId, resources.getLocale(), this.resourceName});
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

