/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.injection;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.map.DefaultedMap;

public abstract class AnnotatedResourcesProvider<K, T, A extends Annotation> {
    private final Map<K, T> resourceMap;
    private final Iterable<T> resources;
    private final Class<A> annotationClass;

    protected AnnotatedResourcesProvider(Class<A> annotationClass) {
        this.resourceMap = Collections.emptyMap();
        this.resources = Collections.emptyList();
        this.annotationClass = annotationClass;
    }

    protected AnnotatedResourcesProvider(Class<A> annotationClass, Iterable<T> resources, T defaultResource) {
        this.resourceMap = new DefaultedMap(defaultResource);
        this.resources = resources;
        this.annotationClass = annotationClass;
    }

    @PostConstruct
    public void setUp() {
        for (T resource : this.resources) {
            A annotation = resource.getClass().getAnnotation(this.annotationClass);
            List<Object> resourceKeys = Collections.emptyList();
            if (annotation != null) {
                resourceKeys = this.getKeyValues(annotation);
            }
            for (Object resourceKey : resourceKeys) {
                this.resourceMap.put(resourceKey, resource);
            }
        }
    }

    protected abstract List<K> getKeyValues(A var1);

    public T provide(K resourceKey) {
        return this.resourceMap.get(resourceKey);
    }
}

