/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class HttpHeaderParser {
    private HttpHeaderParser() {
    }

    public static Map<String, String> parse(InputStream contentStream) throws IOException {
        return HttpHeaderParser.parse(contentStream, Charsets.ISO_8859_1);
    }

    public static Map<String, String> parse(InputStream contentStream, Charset charset) throws IOException {
        Map<String, String> headers;
        List<StringBuilder> headerLines = HttpHeaderParser.readHeaderLines(contentStream, charset);
        if (headerLines.isEmpty()) {
            headers = Collections.emptyMap();
        } else {
            headers = new HashMap<String, String>(headerLines.size(), 1.0f);
            for (int idx = 0; idx < headerLines.size(); ++idx) {
                String headerLine = headerLines.get(idx).toString();
                String[] pair = StringUtils.split((String)headerLine, (char)':');
                if (pair.length != 2) continue;
                headers.put(pair[0].trim(), pair[1].trim());
            }
        }
        return headers;
    }

    private static List<StringBuilder> readHeaderLines(InputStream is, Charset charset) throws IOException {
        ArrayList<StringBuilder> headerLines = new ArrayList<StringBuilder>();
        String line = HttpHeaderParser.readLine(is, charset);
        int idx = 0;
        while (StringUtils.isNotBlank((String)line)) {
            char startCh = line.charAt(0);
            if (idx > 0 && (startCh == ' ' || startCh == '\t')) {
                StringBuilder mainLine = (StringBuilder)headerLines.get(idx - 1);
                mainLine.append(' ').append(line.substring(1));
            } else {
                headerLines.add(new StringBuilder(line));
                ++idx;
            }
            line = HttpHeaderParser.readLine(is, charset);
        }
        return headerLines;
    }

    private static String readLine(InputStream inputStream, Charset charset) throws IOException {
        int end;
        int value;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((value = inputStream.read()) >= 0 && value != 10) {
            buffer.write(value);
        }
        if (buffer.size() == 0) {
            return null;
        }
        byte[] lineBytes = buffer.toByteArray();
        if (lineBytes[(end = lineBytes.length) - 1] == 13) {
            --end;
        }
        return new String(ArrayUtils.subarray((byte[])lineBytes, (int)0, (int)end), charset);
    }
}

