/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.net;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class MediaTypes {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_X_ZIP = "application/x-zip";
    public static final String APPLICATION_X_ZIP_COMPRESSED = "application/x-zip-compressed";
    public static final String APPLICATION_X_COMPRESSED = "application/x-compressed";
    private static final Set<String> ZIP_MEDIA_TYPES;

    private MediaTypes() {
    }

    public static boolean isZip(String contentTypeValue) {
        String[] mediaTypeParts = contentTypeValue.split(";");
        String part0 = mediaTypeParts[0];
        String mediaType = part0 != null ? part0.trim().toLowerCase() : null;
        return ZIP_MEDIA_TYPES.contains(mediaType);
    }

    static {
        HashSet<String> s = new HashSet<String>(5);
        s.addAll(Arrays.asList(APPLICATION_OCTET_STREAM, APPLICATION_X_COMPRESSED, APPLICATION_X_ZIP_COMPRESSED, APPLICATION_X_ZIP, APPLICATION_ZIP));
        ZIP_MEDIA_TYPES = Collections.unmodifiableSet(s);
    }
}

