/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.net;

import com.ibm.ba.gemini.commons.api.GeminiServiceException;
import java.net.URI;
import java.net.URISyntaxException;

public final class UriUtils {
    private UriUtils() {
    }

    public static String encodePath(String path) {
        try {
            URI uri = new URI(null, null, path, null, null);
            return uri.getRawPath();
        }
        catch (URISyntaxException e) {
            throw new GeminiServiceException("Error encoding path: " + path, (Throwable)e);
        }
    }

    public static String encodeQuery(String query) {
        try {
            URI uri = new URI(null, null, null, query, null);
            return uri.getRawQuery();
        }
        catch (URISyntaxException e) {
            throw new GeminiServiceException("Error encoding query: " + query, (Throwable)e);
        }
    }

    public static String encodeFragment(String fragment) {
        try {
            URI uri = new URI(null, null, null, null, fragment);
            return uri.getRawFragment();
        }
        catch (URISyntaxException e) {
            throw new GeminiServiceException("Error encoding fragment: " + fragment, (Throwable)e);
        }
    }
}

