/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.resources;

import com.ibm.ba.gemini.commons.resources.Deletable;
import com.ibm.ba.gemini.commons.resources.DeleteOnShutdownHook;
import java.io.IOException;
import java.io.InputStream;

public class AutoDeletingInputStream
extends InputStream {
    private InputStream in;
    private Deletable deletable;
    private boolean retryDeleteOnShutdown;

    public AutoDeletingInputStream(InputStream in, Deletable deletable) {
        this(in, deletable, true);
    }

    public AutoDeletingInputStream(InputStream in, Deletable deletable, boolean retryDelete) {
        this.in = in;
        this.deletable = deletable;
        this.retryDeleteOnShutdown = retryDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.deletable.delete() && this.retryDeleteOnShutdown) {
                DeleteOnShutdownHook.getInstance().enqueue(this.deletable);
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

