/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.resources;

import com.ibm.ba.gemini.commons.resources.Deletable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOnShutdownHook
extends Thread {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DeleteOnShutdownHook.class);
    private static final DeleteOnShutdownHook INSTANCE = new DeleteOnShutdownHook();
    private List<Deletable> deleteQueue = Collections.synchronizedList(new LinkedList());

    public static DeleteOnShutdownHook getInstance() {
        return INSTANCE;
    }

    private DeleteOnShutdownHook() {
        super("DeleteOnShutdownHook");
        Runtime.getRuntime().addShutdownHook(this);
        LOGGER.debug("Runtime.getRuntime().addShutdownHook({})", (Object)this);
    }

    public void enqueue(Deletable deletable) {
        this.deleteQueue.add(0, deletable);
        LOGGER.debug("Enqueuing '{}' for deletion on shutdown", (Object)deletable);
    }

    @Override
    public void run() {
        LOGGER.debug("running...");
        for (Deletable deletable : this.deleteQueue) {
            if (deletable.delete()) continue;
            LOGGER.warn("Unable to delete '{}' on shutdown", (Object)deletable);
        }
        LOGGER.debug("finished");
    }
}

