/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public final class StringDigest {
    private static final String BASE64_VALID_CHARS = "[A-Za-z0-9-_=]";
    private static final String HEX_VALID_CHARS = "[A-Fa-f0-9]";
    private static final Pattern[][] VALIDATION_PATTERN_TABLE = new Pattern[DigestAlgorithm.values().length][DigestEncoding.values().length];
    private final DigestAlgorithm digestAlgorithm;
    private final DigestEncoding digestEncoding;

    private StringDigest(DigestAlgorithm digestAlgorithm, DigestEncoding digestEncoding) {
        this.digestAlgorithm = digestAlgorithm;
        this.digestEncoding = digestEncoding;
    }

    public String digest(String value) {
        return StringDigest.digest(value, this.digestAlgorithm, this.digestEncoding);
    }

    public boolean isValid(String digest) {
        return StringDigest.isValid(digest, this.digestAlgorithm, this.digestEncoding);
    }

    public static final StringDigest newInstance(DigestAlgorithm algorithm, DigestEncoding encoding) {
        return new StringDigest(algorithm, encoding);
    }

    private static String digest(String value, DigestAlgorithm digestAlgorithm, DigestEncoding digestEncoding) {
        try {
            MessageDigest digest = MessageDigest.getInstance(digestAlgorithm.name());
            digest.update(value.getBytes(Charsets.UTF_8));
            return digestEncoding.encode(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isValid(String digest, DigestAlgorithm digestAlgorithm, DigestEncoding digestEncoding) {
        boolean isValid = false;
        Pattern validationPattern = VALIDATION_PATTERN_TABLE[digestAlgorithm.ordinal()][digestEncoding.ordinal()];
        if (StringUtils.isNotBlank((String)digest) && validationPattern != null) {
            Matcher matcher = validationPattern.matcher(digest);
            isValid = matcher.matches();
        }
        return isValid;
    }

    static {
        StringDigest.VALIDATION_PATTERN_TABLE[DigestAlgorithm.MD5.ordinal()][DigestEncoding.BASE64.ordinal()] = Pattern.compile("^[A-Za-z0-9-_=]{21,24}$");
        StringDigest.VALIDATION_PATTERN_TABLE[DigestAlgorithm.MD5.ordinal()][DigestEncoding.HEX.ordinal()] = Pattern.compile("^[A-Fa-f0-9]{29,32}$");
        StringDigest.VALIDATION_PATTERN_TABLE[DigestAlgorithm.SHA1.ordinal()][DigestEncoding.BASE64.ordinal()] = Pattern.compile("^[A-Za-z0-9-_=]{25,28}$");
        StringDigest.VALIDATION_PATTERN_TABLE[DigestAlgorithm.SHA1.ordinal()][DigestEncoding.HEX.ordinal()] = Pattern.compile("^[A-Fa-f0-9]{37,40}$");
    }

    public static enum DigestEncoding {
        BASE64((BinaryEncoder)new Base64(-1, new byte[0], true)),
        HEX((BinaryEncoder)new Hex(Charsets.UTF_8));

        private final BinaryEncoder codec;

        private DigestEncoding(BinaryEncoder codec) {
            this.codec = codec;
        }

        private String encode(byte[] value) {
            try {
                return new String(this.codec.encode(value), Charsets.UTF_8);
            }
            catch (EncoderException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum DigestAlgorithm {
        MD5,
        SHA1;

    }
}

