/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.IQualityOfService;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalModelType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModelFactory;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.api.util.MultiPartIdentifier;
import com.ibm.cognos.aurora.core.graph.api.ArcFilters;
import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.api.IVertexIndex;
import com.ibm.cognos.aurora.core.graph.api.NoSuchArcException;
import com.ibm.cognos.aurora.core.graph.api.NoSuchVertexException;
import com.ibm.cognos.aurora.core.graph.persist.bin.BinaryGraphReader;
import com.ibm.cognos.aurora.core.graph.persist.bin.BinaryGraphWriter;
import com.ibm.cognos.aurora.core.graph.persist.bin.BinaryValueSerializer;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.model.DataContainer;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import com.ibm.cognos.aurora.core.util.ConcurrentSoftReferenceCache;
import com.ibm.cognos.aurora.core.util.Dictionary;
import com.ibm.cognos.aurora.core.util.SoftReferenceCache;
import com.ibm.cognos.aurora.core.util.collection.EmptyIterable;
import com.ibm.cognos.aurora.core.util.collection.FilteringIterable;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import com.ibm.cognos.aurora.core.util.collection.IMapper;
import com.ibm.cognos.aurora.core.util.collection.MappingIterable;
import com.ibm.cognos.aurora.core.util.collection.UnionIterable;
import com.ibm.cognos.aurora.core.xml.DOM4JUtil;
import com.ibm.cognos.aurora.qls.model.HierarchyManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.dom4j.Document;
import org.dom4j.Element;

public class GraphBackedAssociativeModel
implements IAssociativeModel {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    private final IQueryLogicalStorage mQLS;
    private IConceptInventory mConceptInv;
    private final IGraph mGraph;
    private final IVertexIndex mStableIdIndex;
    private final Map<String, IPhysicalModel> mPhysicalModelsByName = new HashMap<String, IPhysicalModel>();
    private DataContainer mRootContainer;
    private final SoftReferenceCache<Integer, NodeAdapter> mNodeCache = new ConcurrentSoftReferenceCache();
    private final SoftReferenceCache<Integer, EdgeAdapter> mEdgeCache = new ConcurrentSoftReferenceCache();
    private String mFilePath;
    private final Map<IQualityOfService.QOS_FEATURE, String> qualityOfService;
    private final Date mCreationTime;
    private final HierarchyManager hierarchyManager;

    public GraphBackedAssociativeModel(IGraph theGraph) {
        this(null, theGraph);
    }

    public GraphBackedAssociativeModel(IQueryLogicalStorage qls, IGraph theGraph) {
        this.mQLS = qls;
        this.mGraph = theGraph;
        this.mStableIdIndex = this.mGraph.createVertexIndex("stableIdIndex", "__stableId");
        this.mRootContainer = new DataContainer((IAssociativeModel)this, null, "root", "root");
        this.mCreationTime = new Date();
        HashMap<IQualityOfService.QOS_FEATURE, String> qosMap = new HashMap<IQualityOfService.QOS_FEATURE, String>(2);
        qosMap.put(IQualityOfService.QOS_FEATURE.OVERLAPPING_HIERARCHY_SUPPORT, Boolean.FALSE.toString());
        qosMap.put(IQualityOfService.QOS_FEATURE.INSTANT_HIERARCHY_SUPPORT, Boolean.FALSE.toString());
        this.qualityOfService = Collections.unmodifiableMap(qosMap);
        this.hierarchyManager = new HierarchyManager(this);
    }

    SoftReferenceCache<Integer, NodeAdapter> getNodeCache() {
        return this.mNodeCache;
    }

    SoftReferenceCache<Integer, EdgeAdapter> getEdgeCache() {
        return this.mEdgeCache;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public void setConceptInventory(IConceptInventory conceptInv) {
        this.mConceptInv = conceptInv;
    }

    public IConceptInventory getConceptInventory() {
        return this.mConceptInv;
    }

    public Date getCreationTime() {
        return this.mCreationTime;
    }

    public Collection<IPhysicalModel> getPhysicalModels() {
        return Collections.unmodifiableCollection(this.mPhysicalModelsByName.values());
    }

    public IPhysicalModel getPhysicalModel(String dataSourceName) {
        return this.mPhysicalModelsByName.get(dataSourceName);
    }

    public void addPhysicalModel(IPhysicalModel physicalModel) {
        this.mPhysicalModelsByName.put(physicalModel.getDataSource().getName(), physicalModel);
    }

    public IDataContainer getRootContainer() {
        return this.mRootContainer;
    }

    public IDataItem findDataItem(MultiPartIdentifier id) {
        if (id.length() < 2) {
            throw new IllegalArgumentException("Invalid data item id: " + id.toUniqueName());
        }
        return this.findDataItem(id, 1, (IDataContainer)this.mRootContainer);
    }

    private IDataItem findDataItem(MultiPartIdentifier id, int index, IDataContainer container) {
        if (index >= id.length()) {
            return null;
        }
        if (index == id.length() - 1) {
            return container.getDataItemByName(id.getPart(index));
        }
        IDataContainer child = container.getChild(id.getPart(index));
        if (null == child) {
            return null;
        }
        return this.findDataItem(id, index + 1, child);
    }

    public Set<IConcept> getAllConcepts() {
        HashSet<IConcept> conceptsFound = new HashSet<IConcept>();
        for (INode n : this.getNodes()) {
            IConcept concept = n.getConcept();
            if (null == concept) continue;
            conceptsFound.add(concept);
        }
        return conceptsFound;
    }

    public int nodeCount() {
        return this.mGraph.numVertices();
    }

    public Iterable<INode> getNodes() {
        return NodeAdapter.wrap(this, this.mGraph.vertices());
    }

    public INode findNode(String id) {
        if (null == id || id.length() == 0) {
            return null;
        }
        try {
            IVertex adaptee;
            if (id.charAt(0) == '#') {
                int vertexId = Integer.parseInt(id.substring(1));
                adaptee = this.mGraph.getVertex(vertexId);
            } else {
                adaptee = this.mStableIdIndex.lookup((Object)id);
            }
            if (null == adaptee) {
                return null;
            }
            return NodeAdapter.wrap(this, adaptee);
        }
        catch (NoSuchVertexException ex) {
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Iterable<INode> findNodes(IFilter<INode> condition) {
        return new FilteringIterable(this.getNodes(), condition);
    }

    public INode createNode(ENodeType type, IConcept concept, IDataItem dataItem, float confidenceLevel) {
        IVertex v = this.mGraph.newVertex();
        NodeAdapter adapter = NodeAdapter.wrap(this, v);
        adapter.setType(type);
        adapter.setConcept(concept);
        adapter.setConfidenceLevel(confidenceLevel);
        if (null != dataItem) {
            adapter.setDataItem(dataItem);
        }
        return adapter;
    }

    public void deleteNode(String id) {
        INode node = this.findNode(id);
        if (null == node) {
            return;
        }
        IVertex adaptee = ((NodeAdapter)node).getAdaptee();
        this.mNodeCache.remove((Object)adaptee.getId());
        this.mGraph.removeVertex(adaptee);
    }

    public int edgeCount() {
        return this.mGraph.numArcs();
    }

    public Iterable<IEdge> getEdges() {
        return EdgeAdapter.wrap(this, this.mGraph.arcs());
    }

    public IEdge findEdge(String id) {
        try {
            return EdgeAdapter.wrap(this, this.mGraph.getArc(Integer.parseInt(id)));
        }
        catch (NoSuchArcException ex) {
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Iterable<IEdge> findEdges(IFilter<IEdge> condition) {
        return new FilteringIterable(this.getEdges(), condition);
    }

    public IEdge createEdge(INode start, INode end, String label, ECardinality cardinality, boolean isWholePart) {
        IVertex v1 = ((NodeAdapter)start).getAdaptee();
        IVertex v2 = ((NodeAdapter)end).getAdaptee();
        IArc arc = this.mGraph.newArc(v1, v2);
        arc.setLabel(label);
        EdgeAdapter adapter = EdgeAdapter.wrap(this, arc);
        adapter.setCardinality(cardinality);
        adapter.setWholePart(isWholePart);
        return adapter;
    }

    public void deleteEdge(String id) {
        IEdge edge = this.findEdge(id);
        if (null == edge) {
            return;
        }
        IArc adaptee = ((EdgeAdapter)edge).getAdaptee();
        this.mEdgeCache.remove((Object)adaptee.getId());
        this.mGraph.removeArc(adaptee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        ctx.push("associativeModelRef", (Object)this);
        try {
            BinaryValueSerializer valueSerializer = new BinaryValueSerializer();
            BinaryGraphWriter graphWriter = new BinaryGraphWriter(out, valueSerializer);
            graphWriter.writeGraph(this.mGraph);
            out.writeInt(this.mPhysicalModelsByName.size());
            for (IPhysicalModel physModel : this.mPhysicalModelsByName.values()) {
                out.writeShort(physModel.getType().ordinal());
                physModel.encodeBinary(out, ctx);
            }
            this.mRootContainer.encodeBinary(out, ctx);
        }
        finally {
            ctx.pop("associativeModelRef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        ctx.push("associativeModelRef", (Object)this);
        try {
            BinaryValueSerializer valueSerializer = new BinaryValueSerializer();
            BinaryGraphReader graphReader = new BinaryGraphReader(in, valueSerializer);
            this.mGraph.clear();
            graphReader.readGraph(this.mGraph);
            this.mPhysicalModelsByName.clear();
            int sz = in.readInt();
            if (sz > 0) {
                IPhysicalModelFactory physModelFactory = (IPhysicalModelFactory)ctx.peekChecked("physicalModelFactory", IPhysicalModelFactory.class);
                if (null == physModelFactory) {
                    if (null != this.mQLS) {
                        physModelFactory = this.mQLS.getPhysicalModelFactory();
                    } else {
                        throw new RuntimeException("No physical model factory was in context");
                    }
                }
                for (int i = 0; i < sz; ++i) {
                    EPhysicalModelType type = EPhysicalModelType.values()[in.readShort()];
                    IPhysicalModel physModel = physModelFactory.create(type);
                    physModel.decodeBinary(in, ctx);
                    this.addPhysicalModel(physModel);
                }
            }
            this.mRootContainer = new DataContainer((IAssociativeModel)this);
            this.mRootContainer.decodeBinary(in, ctx);
            this.rebuildIndexes();
        }
        finally {
            ctx.pop("associativeModelRef");
        }
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(String path) throws IOException {
        EncoderContext ctx = new EncoderContext();
        ctx.put((Object)"keyDictionary", (Object)new Dictionary());
        FileOutputStream fos = new FileOutputStream(path);
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(fos));
            this.encodeBinary((DataOutput)((Object)dos), ctx);
            this.mFilePath = path;
        }
        finally {
            if (null != dos) {
                dos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(String path) throws IOException {
        EncoderContext ctx = new EncoderContext();
        ctx.put((Object)"keyDictionary", (Object)new Dictionary());
        FileInputStream fis = new FileInputStream(path);
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(fis));
            this.decodeBinary(dis, ctx);
            this.mFilePath = path;
        }
        finally {
            fis.close();
        }
    }

    public void dumpToXML(String path, ISession userSession) {
        Document doc = DOM4JUtil.createDocument();
        this.dumpToXML(doc, userSession);
        try {
            DOM4JUtil.serializeDocument((File)new File(path), (Document)doc, (boolean)true);
        }
        catch (IOException ex) {
            return;
        }
    }

    public String dumpToXML(ISession userSession) {
        Document doc = DOM4JUtil.createDocument();
        this.dumpToXML(doc, userSession);
        try {
            StringWriter writer = new StringWriter();
            DOM4JUtil.serializeDocument((Writer)writer, (Document)doc, (boolean)true);
            return writer.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void rebuildIndexes() {
        this.rebuildStableNodeIds();
    }

    private void rebuildStableNodeIds() {
        for (INode n : this.getNodes()) {
            NodeAdapter adapter = (NodeAdapter)n;
            adapter.setStableId(null);
            if (n.isMetric() || n.isAttribute()) {
                if (null == n.getDataItem()) continue;
                adapter.setStableId("@" + n.getDataItem().getId().toUniqueName());
                continue;
            }
            INode defaultAttr = NavigationHelper.getDefaultAttributeNode((INode)n);
            if (null == defaultAttr || null == defaultAttr.getDataItem()) continue;
            adapter.setStableId("cat:@" + defaultAttr.getDataItem().getId().toUniqueName());
        }
    }

    private void dumpToXML(Document doc, ISession userSession) {
        EncoderContext ctx = new EncoderContext();
        ctx.put((Object)"stableTestOutput", (Object)Boolean.TRUE);
        Element rootElem = doc.addElement("model");
        Element physModelsElem = rootElem.addElement("physicalModels");
        for (IPhysicalModel physModel : this.mPhysicalModelsByName.values()) {
            physModel.encodeElement(physModelsElem.addElement("physicalModel"), ctx);
        }
        this.dumpDataContainerToXML(rootElem.addElement("rootContainer"), (IDataContainer)this.mRootContainer);
        Element nodesElem = rootElem.addElement("nodes");
        for (INode n : this.getNodes()) {
            this.dumpNodeToXML(nodesElem.addElement("node"), n);
        }
        Element hierarchyElem = rootElem.addElement("hierarchies");
        for (IHierarchy hierarchy : this.getHierarchies(userSession)) {
            this.dumpHierarchyToXML(hierarchyElem.addElement("hierarchy"), hierarchy);
        }
        Element edgesElem = rootElem.addElement("edges");
        for (IEdge e : this.getEdges()) {
            this.dumpEdgeToXML(edgesElem.addElement("edge"), e);
        }
    }

    private void dumpDataContainerToXML(Element e, IDataContainer dc) {
        e.addAttribute("id", dc.getId().toUniqueName());
        e.addAttribute("name", dc.getName());
        e.addAttribute("type", dc.getType());
        Element nodesElem = e.addElement("nodes");
        for (INode n : dc.getNodes()) {
            this.dumpNodeToXML(nodesElem.addElement("node"), n);
        }
        Element dataItemsElem = e.addElement("dataItems");
        for (IDataItem di : dc.getDataItems()) {
            this.dumpDataItemToXML(dataItemsElem.addElement("dataItem"), di);
        }
        if (!dc.getChildren().isEmpty()) {
            Element childrenElem = e.addElement("children");
            for (IDataContainer child : dc.getChildren()) {
                this.dumpDataContainerToXML(childrenElem.addElement("container"), child);
            }
        }
    }

    private void dumpDataItemToXML(Element e, IDataItem di) {
        e.addAttribute("name", di.getName());
        e.addAttribute("dataType", di.getDataType().toString());
        if (di.getPhysicalMetadata() != null) {
            IPhysicalMetadata physMetadata = di.getPhysicalMetadata();
            IPhysicalModel physModel = physMetadata.getModel();
            e.addAttribute("physicalModel", physModel.getDataSource().getName());
            e.addAttribute("physicalMetadata", physMetadata.getInternalUniqueName());
        }
        for (String propName : di.getPropertyNames()) {
            if ("TABLE_NAME".equals(propName)) continue;
            IValue propValue = di.getProperty(propName);
            e.addAttribute(propName, propValue.stringValue());
        }
        IDataItemStats stats = di.getStats();
        if (null != stats) {
            e.addElement("count").setText(Long.toString(stats.count()));
            e.addElement("distinctCount").setText(Long.toString(stats.distinctCount()));
            e.addElement("nullCount").setText(Long.toString(stats.nullCount()));
            e.addElement("minValue").setText(String.valueOf(stats.minValue()));
            e.addElement("maxValue").setText(String.valueOf(stats.maxValue()));
        }
    }

    private void dumpNodeToXML(Element e, INode n) {
        e.addAttribute("id", n.getId());
        e.addAttribute("label", n.getLabel());
        e.addAttribute("type", n.getType().toString());
        e.addAttribute("confidenceLevel", Float.toString(n.getConfidenceLevel()));
        if (n.getConcept() != null) {
            e.addAttribute("concept", n.getConcept().getName());
        }
        if (n.getDataItem() != null) {
            e.addAttribute("dataItem", n.getDataItem().getName());
        }
    }

    private void dumpHierarchyToXML(Element e, IHierarchy n) {
        e.addAttribute("uniqueName", n.getUniqueName());
        e.addAttribute("caption", n.getCaption());
        try {
            e.addAttribute("isValues", Boolean.toString(n.isValues()));
        }
        catch (UnsupportedOperationException exception) {
            // empty catch block
        }
        if (!n.isValues()) {
            Element attributes = e.addElement("attributes");
            for (IAttribute attribute : n.getLevels()) {
                this.dumpAttributeToXML(attributes.addElement("attribute"), attribute);
            }
        } else {
            Element attributes = e.addElement("members");
            for (IMember member : n.getRootMembers()) {
                this.dumpMemberToXML(attributes.addElement("member"), member);
            }
        }
    }

    private void dumpAttributeToXML(Element e, IAttribute n) {
        e.addAttribute("uniqueName", n.getUniqueName());
        e.addAttribute("caption", n.getCaption());
    }

    private void dumpMemberToXML(Element e, IMember n) {
        e.addAttribute("uniqueName", n.getUniqueName());
        e.addAttribute("caption", n.getCaption());
    }

    private void dumpEdgeToXML(Element e, IEdge edge) {
        e.addAttribute("id", edge.getId());
        e.addAttribute("label", edge.getLabel());
        e.addAttribute("wholePart", Boolean.toString(edge.isWholePart()));
        e.addAttribute("cardinality", edge.getCardinality().toString());
        e.addAttribute("start", edge.getStart().getId());
        e.addAttribute("end", edge.getEnd().getId());
    }

    public List<IHierarchy> getHierarchies(ISession userSession) {
        this.checkSession(userSession);
        return this.hierarchyManager.getHierarchies(userSession);
    }

    public IHierarchy getHierarchy(ISession userSession, String uniqueName) {
        this.checkSession(userSession);
        return this.hierarchyManager.getHierarchy(userSession, uniqueName);
    }

    public IHierarchy createHierarchy(ISession userSession, IAttribute[] attributes, String name) {
        this.checkSession(userSession);
        return this.hierarchyManager.createHierarchy(userSession, attributes, name);
    }

    public List<IAttribute> getQueryAttributes(ISession userSession) {
        this.checkSession(userSession);
        return this.hierarchyManager.getQueryAttributes(userSession);
    }

    public IAttribute getQueryAttribute(ISession userSession, String name) {
        this.checkSession(userSession);
        return this.hierarchyManager.getQueryAttribute(userSession, name);
    }

    public boolean equals(Object rhs) {
        return this == rhs;
    }

    public String qualityOfService(IQualityOfService.QOS_FEATURE feature) {
        return this.qualityOfService.get(feature);
    }

    protected final void checkSession(ISession userSession) {
        if (null == userSession) {
            throw new UnsupportedOperationException("userSession cannot be null");
        }
    }

    static final class EdgeAdapter
    implements IEdge {
        private static final String PROP_CARDINALITY = "cardinality";
        private static final String PROP_WHOLE_PART = "wholePart";
        private final GraphBackedAssociativeModel mModel;
        private final IArc mAdaptee;

        static EdgeAdapter wrap(GraphBackedAssociativeModel model, IArc adaptee) {
            SoftReferenceCache<Integer, EdgeAdapter> edgeCache = model.getEdgeCache();
            EdgeAdapter edge = (EdgeAdapter)edgeCache.get((Object)adaptee.getId());
            if (null != edge) {
                return edge;
            }
            edge = new EdgeAdapter(model, adaptee);
            edgeCache.put((Object)adaptee.getId(), (Object)edge);
            return edge;
        }

        static Iterable<IEdge> wrap(final GraphBackedAssociativeModel model, Iterable<IArc> adaptee) {
            return new MappingIterable(adaptee, (IMapper)new IMapper<IEdge, IArc>(){

                public IEdge map(IArc v) {
                    return EdgeAdapter.wrap(model, v);
                }
            });
        }

        private EdgeAdapter(GraphBackedAssociativeModel model, IArc adaptee) {
            this.mModel = model;
            this.mAdaptee = adaptee;
        }

        public IAssociativeModel getModel() {
            return this.mModel;
        }

        public IArc getAdaptee() {
            return this.mAdaptee;
        }

        public String getId() {
            return Integer.toString(this.mAdaptee.getId());
        }

        public String getLabel() {
            return this.mAdaptee.getLabel();
        }

        public ECardinality getCardinality() {
            int ordinal = (Integer)this.mAdaptee.getPropertyValue(PROP_CARDINALITY, Integer.class);
            return ECardinality.values()[ordinal];
        }

        void setCardinality(ECardinality cardinality) {
            this.mAdaptee.setPropertyValue(PROP_CARDINALITY, (Object)cardinality.ordinal());
        }

        public boolean isWholePart() {
            return (Boolean)this.mAdaptee.getPropertyValue(PROP_WHOLE_PART, Boolean.class);
        }

        public void setWholePart(boolean wholePart) {
            this.mAdaptee.setPropertyValue(PROP_WHOLE_PART, (Object)wholePart);
        }

        public INode getStart() {
            return NodeAdapter.wrap(this.mModel, this.mAdaptee.getStart());
        }

        public INode getEnd() {
            return NodeAdapter.wrap(this.mModel, this.mAdaptee.getEnd());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getStart().toString()).append("-(").append(this.getLabel()).append(")->").append(this.getEnd().toString());
            return sb.toString();
        }

        public int hashCode() {
            return this.mAdaptee.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EdgeAdapter)) {
                return false;
            }
            EdgeAdapter other = (EdgeAdapter)o;
            return this.mAdaptee.equals(other.mAdaptee);
        }
    }

    static final class NodeAdapter
    implements INode {
        private final GraphBackedAssociativeModel mModel;
        private final IVertex mAdaptee;
        private IDataItem mCachedDataItem;
        private IConcept mCachedConcept;

        static NodeAdapter wrap(GraphBackedAssociativeModel model, IVertex adaptee) {
            SoftReferenceCache<Integer, NodeAdapter> nodeCache = model.getNodeCache();
            NodeAdapter node = (NodeAdapter)nodeCache.get((Object)adaptee.getId());
            if (null != node) {
                return node;
            }
            node = new NodeAdapter(model, adaptee);
            nodeCache.put((Object)adaptee.getId(), (Object)node);
            return node;
        }

        static Iterable<INode> wrap(final GraphBackedAssociativeModel model, Iterable<IVertex> adaptee) {
            return new MappingIterable(adaptee, (IMapper)new IMapper<INode, IVertex>(){

                public INode map(IVertex v) {
                    return NodeAdapter.wrap(model, v);
                }
            });
        }

        NodeAdapter(GraphBackedAssociativeModel model, IVertex adaptee) {
            this.mModel = model;
            this.mAdaptee = adaptee;
        }

        public IAssociativeModel getModel() {
            return this.mModel;
        }

        public IVertex getAdaptee() {
            return this.mAdaptee;
        }

        public String getId() {
            String stableId = (String)this.mAdaptee.getPropertyValue("__stableId", String.class);
            if (null == stableId) {
                return "#" + this.mAdaptee.getId();
            }
            return stableId;
        }

        void setStableId(String id) {
            this.mAdaptee.setPropertyValue("__stableId", (Object)id);
        }

        public String getLabel() {
            String label = (String)this.getProperty("__label");
            if (null != label) {
                return label;
            }
            IDataItem di = this.getDataItem();
            if (null != di) {
                return di.getName();
            }
            return null;
        }

        public Object getProperty(String name) {
            return this.mAdaptee.getPropertyValue(name);
        }

        public void setProperty(String name, Object value) {
            this.mAdaptee.setPropertyValue(name, value);
        }

        public ENodeType getType() {
            int typeOrdinal = (Integer)this.mAdaptee.getPropertyValue("__type", Integer.class);
            return ENodeType.values()[typeOrdinal];
        }

        void setType(ENodeType type) {
            this.mAdaptee.setPropertyValue("__type", (Object)type.ordinal());
        }

        public boolean isCategory() {
            return ENodeType.CATEGORY == this.getType();
        }

        public boolean isMetric() {
            return ENodeType.METRIC == this.getType();
        }

        public boolean isAttribute() {
            return ENodeType.ATTRIBUTE == this.getType();
        }

        public boolean isValue() {
            return ENodeType.VALUE == this.getType();
        }

        public IConcept getConcept() {
            IConceptInventory conceptInv;
            if (null != this.mCachedConcept) {
                return this.mCachedConcept;
            }
            String conceptName = (String)this.mAdaptee.getPropertyValue("__conceptName", String.class);
            if (null != conceptName && null != (conceptInv = this.mModel.getConceptInventory())) {
                this.mCachedConcept = conceptInv.getConcept(conceptName);
            }
            return this.mCachedConcept;
        }

        public void setConcept(IConcept concept) {
            if (null == concept) {
                this.mAdaptee.removeProperty("__conceptName");
            } else {
                this.mAdaptee.setPropertyValue("__conceptName", (Object)concept.getName());
            }
            this.mCachedConcept = concept;
        }

        public IDataItem getDataItem() {
            if (null != this.mCachedDataItem) {
                return this.mCachedDataItem;
            }
            MultiPartIdentifier dataItemId = (MultiPartIdentifier)this.mAdaptee.getPropertyValue("__dataItemId", MultiPartIdentifier.class);
            if (null != dataItemId) {
                this.mCachedDataItem = this.mModel.findDataItem(dataItemId);
            }
            return this.mCachedDataItem;
        }

        public void setDataItem(IDataItem dataItem) {
            this.mCachedDataItem = dataItem;
            if (null == dataItem) {
                this.mAdaptee.removeProperty("__dataItemId");
            } else {
                this.mAdaptee.setPropertyValue("__dataItemId", (Object)dataItem.getId());
            }
        }

        public float getConfidenceLevel() {
            return ((Float)this.mAdaptee.getPropertyValue("__confidenceLevel", Float.class)).floatValue();
        }

        public void setConfidenceLevel(float confidenceLevel) {
            this.mAdaptee.setPropertyValue("__confidenceLevel", (Object)Float.valueOf(confidenceLevel));
        }

        public Iterable<IEdge> getEdges(String ... labels) {
            return EdgeAdapter.wrap(this.mModel, this.mAdaptee.arcs(ArcFilters.hasLabel((String[])labels)));
        }

        public Iterable<IEdge> getOutEdges(String ... labels) {
            return EdgeAdapter.wrap(this.mModel, this.mAdaptee.outArcs(ArcFilters.hasLabel((String[])labels)));
        }

        public Iterable<IEdge> getInEdges(String ... labels) {
            return EdgeAdapter.wrap(this.mModel, this.mAdaptee.inArcs(ArcFilters.hasLabel((String[])labels)));
        }

        public boolean connectsWith(INode other) {
            for (IEdge e : this.getOutEdges(new String[0])) {
                if (!e.getEnd().equals(other)) continue;
                return true;
            }
            for (IEdge e : this.getInEdges(new String[0])) {
                if (!e.getStart().equals(other)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            IDataItem di;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getLabel());
            IConcept concept = this.getConcept();
            if (null != concept) {
                sb.append('(').append(concept.getName()).append(')');
            }
            if (null != (di = this.getDataItem())) {
                sb.append('[').append(di.getName()).append(']');
            }
            return sb.toString();
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.mAdaptee);
            hcb.append((Object)this.mModel);
            return hcb.toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeAdapter)) {
                return false;
            }
            NodeAdapter other = (NodeAdapter)o;
            return this.mAdaptee.equals(other.mAdaptee) && this.mModel.equals(other.mModel);
        }

        public Iterable<INode> getMetricNodesInScope() {
            List cMetrics = this.getConcept().getMetricConceptsInScope();
            if (cMetrics == null || cMetrics.isEmpty()) {
                return new EmptyIterable();
            }
            ArrayList<Iterable<INode>> conceptMatches = new ArrayList<Iterable<INode>>(cMetrics.size());
            for (IConcept c : cMetrics) {
                conceptMatches.add(this.mModel.findNodes((IFilter<INode>)NodeFilters.hasConcept((IConcept)c)));
            }
            return new UnionIterable(conceptMatches);
        }

        public boolean isInScopeWith(INode other) {
            return this.getConcept().isInScopeWith(other.getConcept());
        }
    }
}

