/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.IMemberSortSpec;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalModelType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.model.QueryAttribute;
import com.ibm.cognos.aurora.qls.model.QueryHierarchy;
import com.ibm.cognos.aurora.qls.model.QueryHierarchyOLAP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HierarchyManager {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    private static final IAttribute SPECIAL_VALUES_ATTRIBUTE = new QueryAttribute(true);
    private volatile boolean preDefinedHierarchiesLoaded = false;
    private List<IHierarchy> hierarchyList;
    private final ReadWriteLock hierarchyLock = new ReentrantReadWriteLock();
    private volatile boolean attributesLoaded = false;
    private List<IAttribute> attributeList;
    private final IAssociativeModel model;

    protected HierarchyManager(IAssociativeModel associativeModel) {
        this.model = associativeModel;
    }

    private List<IHierarchy> createHierarchyView() {
        return new ArrayList<IHierarchy>(this.hierarchyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IHierarchy> getHierarchies(ISession userSession) {
        if (this.preDefinedHierarchiesLoaded) {
            this.hierarchyLock.readLock().lock();
            try {
                List<IHierarchy> list = this.createHierarchyView();
                return list;
            }
            finally {
                this.hierarchyLock.readLock().unlock();
            }
        }
        this.hierarchyLock.writeLock().lock();
        try {
            List<IHierarchy> list;
            if (this.preDefinedHierarchiesLoaded) {
                List<IHierarchy> list2 = this.createHierarchyView();
                return list2;
            }
            LocalSessionContext.set((ISession)userSession);
            try {
                IPhysicalModel physicalModel = (IPhysicalModel)this.model.getPhysicalModels().iterator().next();
                NavigationHelper helper = new NavigationHelper(this.model);
                List modelHierarchies = helper.getDetectedHierarchies();
                this.hierarchyList = new ArrayList<IHierarchy>(modelHierarchies.size());
                ArrayList<IAttribute> attributeList = new ArrayList<IAttribute>();
                IOlapCube cube = null;
                for (INode hierarchyRootNode : modelHierarchies) {
                    QueryHierarchy hierarchy;
                    INode identifier = NavigationHelper.getIdentifierAttributeFromCategory((INode)hierarchyRootNode);
                    attributeList.add(new QueryAttribute(identifier));
                    List hierarchyCategories = NavigationHelper.getPartNodes((INode)hierarchyRootNode);
                    for (INode category : hierarchyCategories) {
                        identifier = NavigationHelper.getIdentifierAttributeFromCategory((INode)category);
                        attributeList.add(new QueryAttribute(identifier));
                    }
                    String hierarchyUniqueName = null;
                    String hierarchyCaption = null;
                    identifier = NavigationHelper.getIdentifierAttributeFromCategory((INode)hierarchyRootNode);
                    IDataItem dataItem = identifier.getDataItem();
                    if (physicalModel.getType() == EPhysicalModelType.OLAP) {
                        IOlapLevel levelMetadata = (IOlapLevel)dataItem.getPhysicalMetadata();
                        IOlapHierarchy hierarchyMetadata = levelMetadata.getHierarchy();
                        if (cube == null) {
                            cube = hierarchyMetadata.getCube();
                        }
                        hierarchyUniqueName = hierarchyMetadata.getUniqueName();
                        hierarchyCaption = hierarchyMetadata.getCaption();
                        hierarchy = new QueryHierarchyOLAP(hierarchyUniqueName, hierarchyCaption, attributeList, hierarchyMetadata, this.model);
                    } else {
                        hierarchyUniqueName = identifier.getId();
                        hierarchyCaption = hierarchyRootNode.getConcept().getName();
                        hierarchy = new QueryHierarchy(hierarchyUniqueName, hierarchyCaption, attributeList, this.model);
                    }
                    this.hierarchyList.add(hierarchy);
                    attributeList.clear();
                }
                if (physicalModel.getType() == EPhysicalModelType.OLAP) {
                    IOlapDimension dimension = cube.getMeasureDimension();
                    if (dimension != null) {
                        IOlapHierarchy measuresHierarchy = (IOlapHierarchy)dimension.getHierarchies().get(0);
                        int measuresLevels = measuresHierarchy.getLevels().size();
                        for (int i = 0; i < measuresLevels; ++i) {
                            attributeList.add(SPECIAL_VALUES_ATTRIBUTE);
                        }
                        QueryHierarchyOLAP hierarchy = new QueryHierarchyOLAP(measuresHierarchy.getUniqueName(), measuresHierarchy.getCaption(), attributeList, measuresHierarchy, this.model);
                        this.hierarchyList.add(hierarchy);
                    }
                } else {
                    attributeList.add(SPECIAL_VALUES_ATTRIBUTE);
                    QueryHierarchy measuresHierarchy = new QueryHierarchy("measures", "measures", attributeList, this.model);
                    measuresHierarchy.setIsValues(true);
                    for (IAttribute attribute : this.getQueryAttributes(userSession)) {
                        if (attribute.getNode() == null || !attribute.getNode().isMetric()) continue;
                        measuresHierarchy.getRootMembers().add(new MeasureHierarchyMember(measuresHierarchy, attribute));
                    }
                    this.hierarchyList.add(measuresHierarchy);
                }
                this.preDefinedHierarchiesLoaded = true;
                list = this.createHierarchyView();
            }
            catch (Throwable throwable) {
                LocalSessionContext.set(null);
                throw throwable;
            }
            LocalSessionContext.set(null);
            return list;
        }
        finally {
            this.hierarchyLock.writeLock().unlock();
        }
    }

    protected IHierarchy getHierarchy(ISession userSession, String uniqueName) {
        boolean isAuditDebug;
        PerfLogEvent event = null;
        if (logger.isPerfDebugEnabled()) {
            event = logger.startPerfDebug(this.getClass().getName(), "getHierarchies", "Calling getHierarchies", LogAction.CALL);
        }
        List<IHierarchy> hierarchies = this.getHierarchies(userSession);
        if (event != null) {
            logger.stopPerfDebug(event, "Returned getHierarchies", LogAction.RETURN);
        }
        if (isAuditDebug = logger.isAuditDebugEventEnabled()) {
            HashMap<String, String> hParams = new HashMap<String, String>();
            for (IHierarchy hierarchy : hierarchies) {
                hParams.put(hierarchy.getUniqueName(), hierarchy.toString());
            }
            logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.GETHIERARCHIES, LogDataHelper.createFunctionDebugLogData((String)"getHierarchies", hParams)));
        }
        for (IHierarchy hierarchy : hierarchies) {
            if (!hierarchy.getUniqueName().equals(uniqueName)) continue;
            if (isAuditDebug) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.GETHIERARCHY, LogDataHelper.createFunctionDebugLogData((String)"getHierarchy", (String)"Hierarchy", (String)hierarchy.toString())));
            }
            return hierarchy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHierarchy createHierarchy(ISession userSession, IAttribute[] attributes, String name) {
        IPhysicalModel physicalModel = (IPhysicalModel)this.model.getPhysicalModels().iterator().next();
        if (physicalModel.getType() == EPhysicalModelType.OLAP) {
            throw new UnsupportedOperationException();
        }
        for (IAttribute attribute : attributes) {
            if (attribute != null) continue;
            throw new NullPointerException();
        }
        this.hierarchyLock.writeLock().lock();
        try {
            QueryHierarchy queryHierarchy;
            QueryHierarchy hierarchy = new QueryHierarchy(name, name, Arrays.asList(attributes), this.model);
            int numHierarchies = this.hierarchyList.size();
            for (int i = 0; i < numHierarchies; ++i) {
                if (!this.hierarchyList.get(i).getUniqueName().equals(name)) continue;
                this.hierarchyList.set(i, hierarchy);
                queryHierarchy = hierarchy;
                return queryHierarchy;
            }
            this.hierarchyList.add(hierarchy);
            queryHierarchy = hierarchy;
            return queryHierarchy;
        }
        finally {
            this.hierarchyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IAttribute> getQueryAttributes(ISession userSession) {
        if (this.attributesLoaded) {
            return this.attributeList;
        }
        HierarchyManager hierarchyManager = this;
        synchronized (hierarchyManager) {
            if (this.attributesLoaded) {
                return this.attributeList;
            }
            IPhysicalModel physicalModel = (IPhysicalModel)this.model.getPhysicalModels().iterator().next();
            this.attributeList = new LinkedList<IAttribute>();
            EPhysicalModelType modelType = physicalModel.getType();
            Iterable iterable = this.model.getNodes();
            for (INode node : iterable) {
                QueryAttribute anAttribute;
                if (modelType == EPhysicalModelType.RELATIONAL) {
                    anAttribute = new QueryAttribute(node);
                    this.attributeList.add(anAttribute);
                    continue;
                }
                if (!node.isAttribute() || !"cIdentifier".equals(node.getConcept().getName())) continue;
                anAttribute = new QueryAttribute(node);
                this.attributeList.add(anAttribute);
            }
            this.attributeList.add(SPECIAL_VALUES_ATTRIBUTE);
            this.attributeList = Collections.unmodifiableList(this.attributeList);
            this.attributesLoaded = true;
            return this.attributeList;
        }
    }

    protected IAttribute getQueryAttribute(ISession userSession, String name) {
        List<IAttribute> attributeList = this.getQueryAttributes(userSession);
        for (IAttribute attribute : attributeList) {
            if (!attribute.getUniqueName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    private final class MeasureHierarchyMember
    implements IMember {
        private final IHierarchy hierarchy;
        private final IAttribute attribute;

        public MeasureHierarchyMember(IHierarchy hierarchy, IAttribute attribute) {
            this.hierarchy = hierarchy;
            this.attribute = attribute;
        }

        public IAssociativeModel getReferencedModel() {
            return HierarchyManager.this.model;
        }

        public String getUniqueName() {
            return this.attribute.getUniqueName();
        }

        public String getCaption() {
            return this.attribute.getCaption();
        }

        public IMember getParentMember() {
            return null;
        }

        public List<IMember> getChildMembers() {
            return Collections.emptyList();
        }

        public IHierarchy getHierarchy() {
            return this.hierarchy;
        }

        public IAttribute getAttribute() {
            return this.attribute;
        }

        public int getMemberDepth() {
            return 0;
        }

        public long getChildrenCardinality() {
            return 0L;
        }

        public Comparator<IMember> createComparator(IMemberSortSpec memberSortSpec) {
            String sortByAttributeType = memberSortSpec.getSortByAttributeType();
            if (sortByAttributeType != null && !sortByAttributeType.equals("caption")) {
                throw new UnsupportedOperationException("Members can only be sorted by caption.");
            }
            return new Comparator<IMember>(){

                @Override
                public int compare(IMember object1, IMember object2) {
                    return object1.getCaption().compareTo(object2.getCaption());
                }
            };
        }
    }
}

