/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model;

import com.ibm.cognos.aurora.api.model.EDataSourceType;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataRepository;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataStorage;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public class LocalDataSource
implements IDataSource {
    private final IQueryLogicalStorage mQLS;
    private EDataSourceType mType;
    private String mName;
    private String mStorageUUID;

    public LocalDataSource(IQueryLogicalStorage qls, EDataSourceType type, String name, String storageUUID) {
        this.mQLS = qls;
        this.mType = type;
        this.mName = name;
        this.mStorageUUID = storageUUID;
    }

    public LocalDataSource(IQueryLogicalStorage qls) {
        this.mQLS = qls;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public String getStorageUUID() {
        return this.mStorageUUID;
    }

    public String getName() {
        return this.mName;
    }

    public EDataSourceType getType() {
        return this.mType;
    }

    public IConnectionSpec getConnectionSpec() {
        ILocalDataRepository repo = this.mQLS.getLocalDataRepository();
        ILocalDataStorage storage = repo.getStorage(this.mStorageUUID);
        return storage.getConnectionSpec();
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addElement("type").setText(this.mType.name());
        if (Boolean.TRUE.equals(ctx.get((Object)"stableTestOutput"))) {
            elem.addElement("name").setText("suppressed-for-testing");
            elem.addElement("storageUUID").setText("suppressed-for-testing");
        } else {
            elem.addElement("name").setText(this.mName);
            elem.addElement("storageUUID").setText(this.mStorageUUID);
        }
    }

    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mName = elem.elementText("name");
        this.mType = EDataSourceType.valueOf((String)elem.elementText("type"));
        this.mStorageUUID = elem.elementText("storageUUID");
    }

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeString((DataOutput)out, (String)this.mName);
        out.writeShort(this.mType.ordinal());
        EncodeUtil.writeString((DataOutput)out, (String)this.mStorageUUID);
    }

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mName = EncodeUtil.readString((DataInput)in);
        this.mType = EDataSourceType.values()[in.readShort()];
        this.mStorageUUID = EncodeUtil.readString((DataInput)in);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.mName).append(';');
        sb.append("type=").append(this.mType).append(';');
        sb.append("storageUUID=").append(this.mStorageUUID);
        return sb.toString();
    }
}

