/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryHierarchy
implements IHierarchy {
    private final String uniqueName;
    private final String caption;
    private final List<IAttribute> levels = new ArrayList<IAttribute>();
    protected IMember defaultMember;
    protected List<IMember> rootMembers = new ArrayList<IMember>();
    protected IMember allMember;
    private boolean isValues = false;
    private final IAssociativeModel referencedModel;

    public QueryHierarchy(String hierarchyName, String hierarchyCaption, List<IAttribute> hierarchyLevels, IAssociativeModel referencedModel) {
        this.uniqueName = hierarchyName;
        this.caption = hierarchyCaption;
        this.levels.addAll(hierarchyLevels);
        this.referencedModel = referencedModel;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getCaption() {
        return this.caption;
    }

    public List<IAttribute> getLevels() {
        return Collections.unmodifiableList(this.levels);
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder();
        strBldr.append(this.caption);
        strBldr.append(": ");
        int numLevels = this.levels.size();
        for (int i = 0; i < numLevels; ++i) {
            strBldr.append(this.levels.get(i).toString());
            if (i >= numLevels - 1) continue;
            strBldr.append(" -> ");
        }
        return strBldr.toString();
    }

    public IMember getDefaultMember() {
        return this.defaultMember;
    }

    public IMember getAllMember() {
        return this.allMember;
    }

    public List<IMember> getRootMembers() {
        return this.rootMembers;
    }

    public List<IMember> getMembers() {
        throw new UnsupportedOperationException();
    }

    public List<IMember> getMembers(IAttribute attributeLevel) {
        throw new UnsupportedOperationException();
    }

    public IMember getMember(String uniqueName) {
        for (IMember rootMember : this.rootMembers) {
            IMember aMember = this.findMember(rootMember, uniqueName);
            if (aMember == null) continue;
            return aMember;
        }
        return null;
    }

    private IMember findMember(IMember startMember, String uniqueName) {
        if (uniqueName.equals(startMember.getUniqueName())) {
            return startMember;
        }
        for (IMember childMember : startMember.getChildMembers()) {
            IMember aMember = this.findMember(childMember, uniqueName);
            if (aMember == null) continue;
            return aMember;
        }
        return null;
    }

    public IAssociativeModel getReferencedModel() {
        if (this.referencedModel != null) {
            return this.referencedModel;
        }
        if (this.getLevels() == null || this.getLevels().isEmpty()) {
            return null;
        }
        if (this.getLevels().get(0).getNode() != null) {
            return this.getLevels().get(0).getNode().getModel();
        }
        return null;
    }

    public boolean isValues() {
        return this.isValues;
    }

    public void setIsValues(boolean isValues) {
        this.isValues = isValues;
    }

    public boolean hasAllMemberDefault() {
        List<IMember> roots = this.getRootMembers();
        if (roots.size() > 1) {
            return false;
        }
        IMember defaultMember = this.getDefaultMember();
        if (defaultMember == null) {
            return true;
        }
        IMember rootMember = roots.get(0);
        return defaultMember.getUniqueName().equals(rootMember.getUniqueName());
    }
}

