/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.IMemberLoader;
import com.ibm.cognos.aurora.api.model.IMemberLoaderFactory;
import com.ibm.cognos.aurora.api.model.IMemberTree;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.qls.model.QueryHierarchy;
import com.ibm.cognos.aurora.qls.model.member.ChildMembersLoaderOLAP;
import com.ibm.cognos.aurora.qls.model.member.DepthBasedMemberLoaderOLAP;
import com.ibm.cognos.aurora.qls.model.member.HierarchyMemberLoaderOLAP;
import com.ibm.cognos.aurora.qls.model.member.MemberAndAncestorsLoader;
import com.ibm.cognos.aurora.qls.model.member.MemberTree;
import com.ibm.cognos.aurora.qls.model.member.RootMembersLoaderOLAP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryHierarchyOLAP
extends QueryHierarchy {
    private final IOlapHierarchy olapHierarchy;
    private final Map<IOlapLevel, IAttribute> olapLevelToAttribute = new HashMap<IOlapLevel, IAttribute>();
    private final Map<IAttribute, IOlapLevel> attributeToOlapLevel = new HashMap<IAttribute, IOlapLevel>();
    private final IMemberTree memberTree;

    public QueryHierarchyOLAP(String hierarchyName, String hierarchyCaption, List<IAttribute> hierarchyLevels, IOlapHierarchy hierarchy, IAssociativeModel model) {
        super(hierarchyName, hierarchyCaption, hierarchyLevels, model);
        this.olapHierarchy = hierarchy;
        List levels = this.olapHierarchy.getLevels();
        for (IOlapLevel aLevel : levels) {
            IAttribute attribute = this.findAttribute(aLevel);
            this.olapLevelToAttribute.put(aLevel, attribute);
            this.attributeToOlapLevel.put(attribute, aLevel);
        }
        this.memberTree = new MemberTree(this, new OLAPMemberLoaderFactory());
        IOlapMember defaultMemberOLAP = this.olapHierarchy.getDefaultMember();
        if (defaultMemberOLAP != null) {
            this.memberTree.setDefaultMember(defaultMemberOLAP.getUniqueName());
        }
        this.rootMembers.addAll(this.memberTree.getRootMembers());
        this.defaultMember = this.memberTree.getDefaultMember();
    }

    Map<IOlapLevel, IAttribute> getLevelToAttributeMap() {
        return this.olapLevelToAttribute;
    }

    private IAttribute findAttribute(IOlapLevel level) {
        for (IAttribute attribute : this.getLevels()) {
            IDataItem dataItem;
            INode node = attribute.getNode();
            if (node == null || (dataItem = node.getDataItem()) == null || dataItem.getPhysicalMetadata() != level) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public List<IMember> getMembers() {
        return new ArrayList<IMember>(this.memberTree.getMembers());
    }

    @Override
    public List<IMember> getMembers(IAttribute attributeLevel) {
        IOlapLevel level = this.attributeToOlapLevel.get(attributeLevel);
        if (level == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IMember>(this.memberTree.getMembers(level.getLevelNumber()));
    }

    @Override
    public IMember getMember(String uniqueName) {
        return this.memberTree.getMember(uniqueName);
    }

    public IOlapHierarchy getOLAPHierarchy() {
        return this.olapHierarchy;
    }

    public IPhysicalModel getModel() {
        return this.olapHierarchy.getModel();
    }

    @Override
    public boolean isValues() {
        return this.olapHierarchy.getDimension().isMeasureDimension();
    }

    class OLAPMemberLoaderFactory
    implements IMemberLoaderFactory {
        OLAPMemberLoaderFactory() {
        }

        public IMemberLoader createHierarchyMembersLoader() {
            return new HierarchyMemberLoaderOLAP(QueryHierarchyOLAP.this.olapHierarchy);
        }

        public IMemberLoader createHierarchyMembersLoader(int startDepth, int endDepth) {
            return new DepthBasedMemberLoaderOLAP(QueryHierarchyOLAP.this.olapHierarchy, startDepth, endDepth);
        }

        public IMemberLoader createRootMembersLoader() {
            return new RootMembersLoaderOLAP(QueryHierarchyOLAP.this.olapHierarchy);
        }

        public IMemberLoader createMemberLoader(String uniqueName) {
            return new MemberAndAncestorsLoader(QueryHierarchyOLAP.this.olapHierarchy, uniqueName);
        }

        public IMemberLoader createChildMembersLoader(IMember aMember) {
            return new ChildMembersLoaderOLAP(QueryHierarchyOLAP.this.olapHierarchy, aMember.getUniqueName());
        }
    }
}

