/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.cache;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.cache.IAssociativeModelCache;
import com.ibm.cognos.aurora.api.model.cache.IAssociativeModelReservation;
import com.ibm.cognos.aurora.api.model.physical.event.EPhysicalModelEventType;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelEventListener;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelWatcher;
import com.ibm.cognos.aurora.api.model.physical.event.PhysicalModelEvent;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AssociativeModelReservation
implements IAssociativeModelReservation {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.model.cache");
    private final IAssociativeModelCache mCache;
    private final Object mCacheKey;
    private final IAssociativeModel mModel;
    private final IPhysicalModelWatcher[] mWatchers;
    private final Lock mLock = new ReentrantLock();
    private volatile boolean mStale = false;
    private volatile boolean mDisposed = false;
    private volatile int mReservationCount = 0;
    private volatile long mReservationStamp = 0L;

    public AssociativeModelReservation(IAssociativeModelCache cache, Object cacheKey, IAssociativeModel model, IPhysicalModelWatcher[] watchers) {
        this.mCache = cache;
        this.mCacheKey = cacheKey;
        this.mModel = model;
        this.mWatchers = watchers;
        ModelListener listener = new ModelListener();
        for (IPhysicalModelWatcher w : this.mWatchers) {
            w.addListener((IPhysicalModelEventListener)listener);
        }
    }

    public IAssociativeModelCache getCache() {
        return this.mCache;
    }

    public Object getCacheKey() {
        return this.mCacheKey;
    }

    public IAssociativeModel getModel() {
        return this.mModel;
    }

    public boolean isStale() {
        return this.mStale;
    }

    void setStale() {
        this.mStale = true;
    }

    public boolean isAvailable() {
        if (this.mDisposed) {
            return false;
        }
        for (IPhysicalModelWatcher w : this.mWatchers) {
            if (null == w || w.isDataSourceAvailable(false)) continue;
            return false;
        }
        return true;
    }

    public Date getLastMetadataChange() {
        Date d = new Date(0L);
        for (IPhysicalModelWatcher w : this.mWatchers) {
            if (null == w || !w.getLastMetadataChange().after(d)) continue;
            d = w.getLastMetadataChange();
        }
        return d;
    }

    public Date getLastDataChange() {
        Date d = new Date(0L);
        for (IPhysicalModelWatcher w : this.mWatchers) {
            if (null == w || !w.getLastMetadataChange().after(d)) continue;
            d = w.getLastDataChange();
        }
        return d;
    }

    public IPhysicalModelWatcher[] getWatchers() {
        return Arrays.copyOf(this.mWatchers, this.mWatchers.length);
    }

    public int reservationCount() {
        return this.mReservationCount;
    }

    long millisSinceLastReservation() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.mReservationStamp);
    }

    void reserve() {
        if (this.mDisposed) {
            throw new IllegalStateException("Reservation was disposed");
        }
        int count = ++this.mReservationCount;
        this.mReservationStamp = System.nanoTime();
        if (logger.isDebugEnabled()) {
            String msg = String.format("Incremented reservation count (key=%s, id=%h, count=%d)", this.getCacheKey(), this, count);
            logger.debug(msg, this.getClass().getName() + "::reserve()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mDisposed) {
            throw new IllegalStateException("Reservation was disposed");
        }
        this.lock();
        try {
            if (this.mReservationCount <= 0) {
                logger.error("Reservation count <= 0", this.getClass().getName() + "::release()");
                throw new IllegalStateException("Reservation count <= 0");
            }
            --this.mReservationCount;
        }
        finally {
            this.unlock();
        }
    }

    boolean updateWatchers() {
        if (this.mDisposed) {
            return false;
        }
        boolean hasUpdates = false;
        for (IPhysicalModelWatcher w : this.mWatchers) {
            if (null == w) continue;
            hasUpdates |= w.update();
        }
        return hasUpdates;
    }

    void lock() {
        this.mLock.lock();
    }

    void unlock() {
        this.mLock.unlock();
    }

    boolean isDisposed() {
        return this.mDisposed;
    }

    void dispose() {
        if (this.mDisposed) {
            return;
        }
        if (this.mReservationCount != 0) {
            logger.error("Reservation count != 0", this.getClass().getName() + "::dispose()");
            throw new IllegalStateException("Reservation count != 0");
        }
        if (logger.isDebugEnabled()) {
            String msg = String.format("Disposing reservation (key=%s, id=%h)", this.getCacheKey(), this);
            logger.debug(msg, this.getClass().getName() + "::dispose()");
        }
        this.mDisposed = true;
        for (IPhysicalModelWatcher w : this.mWatchers) {
            if (null == w) continue;
            w.dispose();
        }
    }

    private final class ModelListener
    implements IPhysicalModelEventListener {
        private ModelListener() {
        }

        public void onConnect(IPhysicalModelWatcher watcher) {
        }

        public void onDisconnect(IPhysicalModelWatcher watcher) {
        }

        public void onEvent(PhysicalModelEvent event) {
            if (event.getEventType() == EPhysicalModelEventType.METADATA_CHANGE) {
                AssociativeModelReservation.this.mStale = true;
            }
        }
    }
}

