/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.member;

import com.ibm.cognos.aurora.api.model.IMemberLoader;
import com.ibm.cognos.aurora.api.model.MemberRecord;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import java.util.Iterator;

public abstract class AbstractMembersLoaderOLAP
implements IMemberLoader,
Iterator<MemberRecord> {
    private Iterator<IOlapMember> memberIterator;
    private final MemberRecord currentRecord = new MemberRecord();
    protected final IOlapHierarchy physicalHierarchy;

    public AbstractMembersLoaderOLAP(IOlapHierarchy hierarchy) {
        this.physicalHierarchy = hierarchy;
    }

    @Override
    public final boolean hasNext() {
        return this.memberIterator.hasNext();
    }

    @Override
    public final MemberRecord next() {
        IOlapMember olapMember = this.memberIterator.next();
        IOlapLevel currentLevel = olapMember.getLevel();
        this.currentRecord.setMemberUniqueName(olapMember.getUniqueName());
        this.currentRecord.setCaption(olapMember.getCaption());
        this.currentRecord.setParentUniqueName(olapMember.getParentUniqueName());
        this.currentRecord.setDepth(currentLevel.getLevelNumber());
        this.currentRecord.setChildrenCardinality(olapMember.getChildrenCardinality());
        this.currentRecord.setOrdinal(olapMember.getOrdinal());
        return this.currentRecord;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final Iterator<MemberRecord> load() {
        this.memberIterator = this.loadImpl();
        return this;
    }

    public abstract Iterator<IOlapMember> loadImpl();
}

