/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical;

import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalMetadata;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPhysicalModelBuilder {
    private IQueryLogicalStorage mQLS;
    private IDataSource mDataSource;
    private ULocale mLocale = new ULocale("en_US@calendar=gregorian");
    private final Map<Pair<EPhysicalMetadataType, String>, String> mInternalNameSubstitutionMap = new HashMap<Pair<EPhysicalMetadataType, String>, String>();

    public final IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public final void setQLS(IQueryLogicalStorage qls) {
        this.mQLS = qls;
    }

    public final IDataSource getDataSource() {
        return this.mDataSource;
    }

    public final void setDataSource(IDataSource dataSource) {
        this.mDataSource = dataSource;
    }

    public final ULocale getLocale() {
        return this.mLocale;
    }

    public final void setLocale(ULocale locale) {
        this.mLocale = locale;
    }

    public final void addInternalNameSubstitution(EPhysicalMetadataType mdType, String internalName, String substitution) {
        this.mInternalNameSubstitutionMap.put((Pair<EPhysicalMetadataType, String>)new Pair((Object)mdType, (Object)internalName), substitution);
    }

    protected final void substituteInternalName(AbstractPhysicalMetadata metadata) {
        String substitution = this.mInternalNameSubstitutionMap.get(new Pair((Object)metadata.getType(), (Object)metadata.getInternalName()));
        if (null != substitution) {
            metadata.setInternalName(substitution);
        }
    }

    public abstract IPhysicalModel build();
}

