/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalModelType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModelFactory;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapModel;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModel;

public class PhysicalModelFactory
implements IPhysicalModelFactory {
    private final IQueryLogicalStorage mQLS;

    public PhysicalModelFactory(IQueryLogicalStorage qls) {
        this.mQLS = qls;
    }

    public IPhysicalModel create(EPhysicalModelType type) {
        AbstractPhysicalModel instance = null;
        switch (type) {
            case OLAP: {
                instance = new OlapModel();
                break;
            }
            case RELATIONAL: {
                instance = new RelModel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupport model type: " + type.name());
            }
        }
        instance.setQLS(this.mQLS);
        return instance;
    }
}

