/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.query.provider.dim.ICubeRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IMeasureRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import com.ibm.cognos.aurora.core.util.SoftReferenceCache;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.olap.AbstractOlapMetadata;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMeasure;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapMember;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.dom4j.Element;

public final class OlapCube
extends AbstractOlapMetadata
implements IOlapCube {
    private String mCatalogName;
    private volatile Date mLastSchemaUpdate;
    private volatile Date mLastDataUpdate;
    private volatile IOlapDimension mCachedMeasureDim;
    private volatile IOlapDimension mCachedTimeDim;
    private final SoftReferenceCache<String, IOlapMember> mMemberCache = new SoftReferenceCache();

    public OlapCube(IOlapModel model) {
        super(model, null);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.OLAP_CUBE;
    }

    public String getCatalogName() {
        return this.mCatalogName;
    }

    public void setCatalogName(String catalogName) {
        this.mCatalogName = catalogName;
    }

    public Date getLastSchemaUpdate() {
        return this.mLastSchemaUpdate;
    }

    public void setLastSchemaUpdate(Date lastSchemaUpdate) {
        this.mLastSchemaUpdate = lastSchemaUpdate;
    }

    public Date getLastDataUpdate() {
        return this.mLastDataUpdate;
    }

    public void setLastDataUpdate(Date lastDataUpdate) {
        this.mLastDataUpdate = lastDataUpdate;
    }

    public List<IOlapDimension> getDimensions() {
        return this.getChildren(EPhysicalMetadataType.OLAP_DIMENSION, IOlapDimension.class);
    }

    public IOlapDimension findDimension(String dimensionUniqueName) {
        for (IOlapDimension dim : this.getDimensions()) {
            if (!dim.getUniqueName().equals(dimensionUniqueName)) continue;
            return dim;
        }
        return null;
    }

    public void addDimension(IOlapDimension dim) {
        this.addChild((IPhysicalMetadata)dim);
    }

    public IOlapDimension getMeasureDimension() {
        if (null == this.mCachedMeasureDim) {
            for (IOlapDimension dim : this.getDimensions()) {
                if (!dim.isMeasureDimension()) continue;
                this.mCachedMeasureDim = dim;
                break;
            }
        }
        return this.mCachedMeasureDim;
    }

    public IOlapDimension getTimeDimension() {
        if (null == this.mCachedTimeDim) {
            for (IOlapDimension dim : this.getDimensions()) {
                if (!dim.isTimeDimension()) continue;
                this.mCachedTimeDim = dim;
                break;
            }
            if (null == this.mCachedTimeDim) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_TimeDimensionNotKnown);
            }
        }
        return this.mCachedTimeDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IOlapMember> fetchMembers(String memberUniqueName, EnumSet<ETreeOp> treeOps) {
        IQueryLogicalStorage qls = ((AbstractPhysicalModel)this.getModel()).getQLS();
        IProviderManager providerMan = qls.getProviderManager();
        IDataSource dataSource = this.getModel().getDataSource();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        IDimensionalDataProvider provider = (IDimensionalDataProvider)providerMan.getDataProvider(providerType);
        Restrictions restrictions = new Restrictions();
        restrictions.put("CATALOG_NAME", this.getCatalogName());
        restrictions.put("CUBE_NAME", this.getName());
        restrictions.put("MEMBER_UNIQUE_NAME", memberUniqueName);
        restrictions.put("TREEOPS", treeOps);
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        queryContext.setContentLocale(this.getModel().getLocale().toLocale());
        try {
            List records = provider.discoverMembers(dataSource, (IRestrictions)restrictions, (IQueryContext)queryContext);
            ArrayList<IOlapMember> result = new ArrayList<IOlapMember>(records.size());
            for (IMemberRecord rec : records) {
                result.add(this.getMemberFromRecord(rec));
            }
            ArrayList<IOlapMember> arrayList = result;
            return arrayList;
        }
        finally {
            queryContext.terminate();
        }
    }

    public void populateFromRecord(ICubeRecord record) {
        this.setInternalName(record.getCubeName());
        this.setName(record.getCubeName());
        this.setUniqueName(record.getCubeName());
        this.setCaption(record.getCaption());
        this.setCatalogName(record.getCatalogName());
        this.setLastDataUpdate(record.getLastDataUpdate());
        this.setLastSchemaUpdate(record.getLastSchemaUpdate());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        boolean stableTestOut;
        super.encodePropertiesElement(elem, ctx);
        if (null != this.mCatalogName) {
            elem.addElement("catalogName").setText(this.mCatalogName);
        }
        if (!(stableTestOut = Boolean.TRUE.equals(ctx.get((Object)"stableTestOutput")))) {
            if (null != this.mLastSchemaUpdate) {
                elem.addElement("lastSchemaUpdate").setText(ValueFactory.createTimestamp((Date)this.mLastSchemaUpdate).stringValue());
            }
            if (null != this.mLastDataUpdate) {
                elem.addElement("lastDataUpdate").setText(ValueFactory.createTimestamp((Date)this.mLastDataUpdate).stringValue());
            }
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        TimestampValue ts;
        super.decodePropertiesElement(elem, ctx);
        this.mCachedMeasureDim = null;
        this.mCachedTimeDim = null;
        Element propElem = elem.element("catalogName");
        this.mCatalogName = null != propElem ? propElem.getText() : null;
        propElem = elem.element("lastSchemaUpdate");
        if (null != propElem) {
            ts = ValueFactory.createTimestamp();
            ts.assignFrom(propElem.getText());
            this.mLastSchemaUpdate = ts.dateValue();
            if (null == this.mLastSchemaUpdate) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_UnableToParseTimeStamp, propElem.getText());
            }
        } else {
            this.mLastSchemaUpdate = null;
        }
        if (null != (propElem = elem.element("lastDataUpdate"))) {
            ts = ValueFactory.createTimestamp();
            ts.assignFrom(propElem.getText());
            this.mLastDataUpdate = ts.dateValue();
            if (null == this.mLastDataUpdate) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_UnableToParseTimeStamp, propElem.getText());
            }
        } else {
            this.mLastDataUpdate = null;
        }
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodePropertiesBinary(out, ctx);
        if (null != this.mCatalogName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mCatalogName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mLastSchemaUpdate) {
            out.writeBoolean(true);
            out.writeLong(this.mLastSchemaUpdate.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mLastDataUpdate) {
            out.writeBoolean(true);
            out.writeLong(this.mLastDataUpdate.getTime());
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodePropertiesBinary(in, ctx);
        this.mCachedMeasureDim = null;
        this.mCachedTimeDim = null;
        this.mCatalogName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mLastSchemaUpdate = in.readBoolean() ? new Date(in.readLong()) : null;
        this.mLastDataUpdate = in.readBoolean() ? new Date(in.readLong()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOlapMember getMemberFromRecord(IMemberRecord record) {
        IOlapMember result = null;
        SoftReferenceCache<String, IOlapMember> softReferenceCache = this.mMemberCache;
        synchronized (softReferenceCache) {
            result = (IOlapMember)this.mMemberCache.get((Object)record.getUniqueName());
        }
        if (null != result) {
            return result;
        }
        IOlapDimension dimension = this.findDimension(record.getDimensionUniqueName());
        if (null == dimension) {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_DimensionNotFound, record.getDimensionUniqueName());
        }
        IOlapHierarchy hierarchy = dimension.findHierarchy(record.getHierarchyUniqueName());
        if (null == hierarchy) {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_HierarchyNotFound, record.getHierarchyUniqueName());
        }
        IOlapLevel level = (IOlapLevel)hierarchy.getLevels().get(record.getLevelNumber());
        if (dimension.isMeasureDimension()) {
            OlapMeasure measure = new OlapMeasure(this.getOlapModel(), level);
            measure.populateFromRecord(record);
            measure.populateFromRecord(this.fetchMeasureRecord(record.getUniqueName()));
            result = measure;
        } else {
            OlapMember member = new OlapMember(this.getOlapModel(), level);
            member.populateFromRecord(record);
            result = member;
        }
        SoftReferenceCache<String, IOlapMember> softReferenceCache2 = this.mMemberCache;
        synchronized (softReferenceCache2) {
            this.mMemberCache.put((Object)result.getUniqueName(), (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMeasureRecord fetchMeasureRecord(String measureUniqueName) {
        IQueryLogicalStorage qls = ((AbstractPhysicalModel)this.getModel()).getQLS();
        IProviderManager providerMan = qls.getProviderManager();
        IDataSource dataSource = this.getModel().getDataSource();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        IDimensionalDataProvider provider = (IDimensionalDataProvider)providerMan.getDataProvider(providerType);
        Restrictions restrictions = new Restrictions();
        restrictions.put("CATALOG_NAME", this.getCatalogName());
        restrictions.put("CUBE_NAME", this.getName());
        restrictions.put("MEASURE_UNIQUE_NAME", measureUniqueName);
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        queryContext.setContentLocale(this.getModel().getLocale().toLocale());
        try {
            List records = provider.discoverMeasures(dataSource, (IRestrictions)restrictions, (IQueryContext)queryContext);
            if (records.size() != 1) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_WrongRecordSize, XQEIntegerPool.getInteger((int)1), (Object)XQEIntegerPool.getInteger((int)records.size()));
            }
            IMeasureRecord iMeasureRecord = (IMeasureRecord)records.get(0);
            return iMeasureRecord;
        }
        finally {
            queryContext.terminate();
        }
    }
}

