/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.provider.dim.EDimensionType;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.olap.AbstractOlapMetadata;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public final class OlapDimension
extends AbstractOlapMetadata
implements IOlapDimension {
    private int mOrdinal;
    private long mCardinality;
    private EDimensionType mDimensionType = EDimensionType.REGULAR;
    private String mDefaultHUN;
    private volatile IOlapHierarchy mCachedDefaultHierarchy;

    public OlapDimension(IOlapModel model, IOlapCube parent) {
        super(model, (IOlapMetadata)parent);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.OLAP_DIMENSION;
    }

    public IOlapCube getCube() {
        return (IOlapCube)this.getParent();
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public void setOrdinal(int ordinal) {
        this.mOrdinal = ordinal;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public void setCardinality(long cardinality) {
        this.mCardinality = cardinality;
    }

    public EDimensionType getDimensionType() {
        return this.mDimensionType;
    }

    public void setDimensionType(EDimensionType dimType) {
        this.mDimensionType = dimType;
    }

    public boolean isMeasureDimension() {
        return EDimensionType.MEASURE == this.mDimensionType;
    }

    public boolean isTimeDimension() {
        return EDimensionType.TIME == this.mDimensionType;
    }

    public List<IOlapHierarchy> getHierarchies() {
        return this.getChildren(EPhysicalMetadataType.OLAP_HIERARCHY, IOlapHierarchy.class);
    }

    public IOlapHierarchy findHierarchy(String hierarchyUniqueName) {
        for (IOlapHierarchy hier : this.getHierarchies()) {
            if (!hier.getUniqueName().equals(hierarchyUniqueName)) continue;
            return hier;
        }
        return null;
    }

    public void addHierarchy(IOlapHierarchy hier) {
        this.addChild((IPhysicalMetadata)hier);
    }

    public IOlapHierarchy getDefaultHierarchy() {
        if (null == this.mCachedDefaultHierarchy) {
            if (null != this.mDefaultHUN) {
                this.mCachedDefaultHierarchy = this.findHierarchy(this.mDefaultHUN);
                if (null == this.mCachedDefaultHierarchy) {
                    throw new QLSRuntimeException(QLSMessageKeys.MOD_HierarchyNotFound, this.mDefaultHUN);
                }
            } else {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_DefaultHierarchyNotKnown);
            }
        }
        return this.mCachedDefaultHierarchy;
    }

    public void setDefaultHUN(String defaultHUN) {
        this.mCachedDefaultHierarchy = null;
        this.mDefaultHUN = defaultHUN;
    }

    public void setDefaultHierarchy(IOlapHierarchy defaultHier) {
        this.mCachedDefaultHierarchy = defaultHier;
        this.mDefaultHUN = defaultHier.getUniqueName();
    }

    public void populateFromRecord(IDimensionRecord record) {
        this.mCachedDefaultHierarchy = null;
        this.setInternalName(record.getName());
        this.setName(record.getName());
        this.setUniqueName(record.getUniqueName());
        this.setCaption(record.getCaption());
        this.setOrdinal(record.getOrdinal());
        this.setCardinality(record.getCardinality());
        this.setDefaultHUN(record.getDefaultHierarchy());
        this.setDimensionType(record.getDimensionType());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        super.encodePropertiesElement(elem, ctx);
        elem.addElement("ordinal").setText(Integer.toString(this.mOrdinal));
        elem.addElement("cardinality").setText(Long.toString(this.mCardinality));
        if (null != this.mDimensionType) {
            elem.addElement("dimensionType").setText(this.mDimensionType.name());
        } else {
            elem.addElement("dimensionType").setText(EDimensionType.UNKNOWN.name());
        }
        if (null != this.mDefaultHUN) {
            elem.addElement("defaultHUN").setText(this.mDefaultHUN);
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        super.decodePropertiesElement(elem, ctx);
        this.mCachedDefaultHierarchy = null;
        this.mOrdinal = Integer.parseInt(elem.elementText("ordinal"));
        this.mCardinality = Long.parseLong(elem.elementText("cardinality"));
        this.mDimensionType = EDimensionType.valueOf((String)elem.elementText("dimensionType"));
        this.mDefaultHUN = elem.elementText("defaultHUN");
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodePropertiesBinary(out, ctx);
        out.writeInt(this.mOrdinal);
        out.writeLong(this.mCardinality);
        if (null != this.mDimensionType) {
            out.writeShort(this.mDimensionType.ordinal());
        } else {
            out.writeShort(EDimensionType.UNKNOWN.ordinal());
        }
        if (null != this.mDefaultHUN) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mDefaultHUN);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodePropertiesBinary(in, ctx);
        this.mOrdinal = in.readInt();
        this.mCardinality = in.readLong();
        this.mDimensionType = EDimensionType.values()[in.readShort()];
        this.mCachedDefaultHierarchy = null;
        this.mDefaultHUN = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
    }
}

