/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMemberProperty;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.ILevelRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.olap.AbstractOlapMetadata;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapCube;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class OlapLevel
extends AbstractOlapMetadata
implements IOlapLevel {
    private int mLevelNumber;
    private long mCardinality;

    public OlapLevel(IOlapModel model, IOlapHierarchy parent) {
        super(model, (IOlapMetadata)parent);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.OLAP_LEVEL;
    }

    public IOlapCube getCube() {
        return this.getDimension().getCube();
    }

    public IOlapDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    public IOlapHierarchy getHierarchy() {
        return (IOlapHierarchy)this.getParent();
    }

    public int getLevelNumber() {
        return this.mLevelNumber;
    }

    public void setLevelNumber(int levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public void setCardinality(long cardinality) {
        this.mCardinality = cardinality;
    }

    public List<IOlapMemberProperty> getMemberProperties() {
        return this.getChildren(EPhysicalMetadataType.OLAP_MEMBER_PROPERTY, IOlapMemberProperty.class);
    }

    public void addMemberProperty(IOlapMemberProperty prop) {
        this.addChild((IPhysicalMetadata)prop);
    }

    public IOlapMemberProperty findMemberProperty(String propertyUniqueName) {
        for (IOlapMemberProperty prop : this.getMemberProperties()) {
            if (!prop.getUniqueName().equals(propertyUniqueName)) continue;
            return prop;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IOlapMember> fetchMembers() {
        IQueryLogicalStorage qls = ((AbstractPhysicalModel)this.getModel()).getQLS();
        IProviderManager providerMan = qls.getProviderManager();
        IDataSource dataSource = this.getModel().getDataSource();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        IDimensionalDataProvider provider = (IDimensionalDataProvider)providerMan.getDataProvider(providerType);
        OlapCube cube = (OlapCube)this.getCube();
        Restrictions restrictions = new Restrictions();
        restrictions.put("CATALOG_NAME", cube.getCatalogName());
        restrictions.put("CUBE_NAME", cube.getName());
        if (this.getHierarchy().isParentChild()) {
            restrictions.put("HIERARCHY_UNIQUE_NAME", this.getHierarchy().getUniqueName());
            restrictions.put("LEVEL_NUMBER", this.getLevelNumber());
        } else {
            restrictions.put("LEVEL_UNIQUE_NAME", this.getUniqueName());
        }
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        queryContext.setContentLocale(this.getModel().getLocale().toLocale());
        try {
            List records = provider.discoverMembers(dataSource, (IRestrictions)restrictions, (IQueryContext)queryContext);
            ArrayList<IOlapMember> members = new ArrayList<IOlapMember>(records.size());
            for (IMemberRecord rec : records) {
                members.add(cube.getMemberFromRecord(rec));
            }
            ArrayList<IOlapMember> arrayList = members;
            return arrayList;
        }
        finally {
            queryContext.terminate();
        }
    }

    public void populateFromRecord(ILevelRecord record) {
        this.setInternalName(record.getName());
        this.setName(record.getName());
        this.setUniqueName(record.getUniqueName());
        this.setCaption(record.getCaption());
        this.setCardinality(record.getCardinality());
        this.setLevelNumber(record.getLevelNumber());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        super.encodePropertiesElement(elem, ctx);
        elem.addElement("levelNumber").setText(Integer.toString(this.mLevelNumber));
        elem.addElement("cardinality").setText(Long.toString(this.mCardinality));
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        super.decodePropertiesElement(elem, ctx);
        this.mLevelNumber = Integer.parseInt(elem.elementText("levelNumber"));
        this.mCardinality = Long.parseLong(elem.elementText("cardinality"));
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodePropertiesBinary(out, ctx);
        out.writeInt(this.mLevelNumber);
        out.writeLong(this.mCardinality);
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodePropertiesBinary(in, ctx);
        this.mLevelNumber = in.readInt();
        this.mCardinality = in.readLong();
    }
}

