/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMeasure;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapCube;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapHierarchy;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class OlapMeasureHierarchy
extends OlapHierarchy {
    private final HashMap<String, IOlapMeasure> mCachedMeasuresByMUN = new HashMap();

    public OlapMeasureHierarchy(IOlapModel model, IOlapDimension parent) {
        super(model, parent);
    }

    public void addMeasure(IOlapMeasure measure) {
        this.mCachedMeasuresByMUN.put(measure.getUniqueName(), measure);
    }

    @Override
    public IOlapMember getDefaultMember() {
        if (null == this.mCachedDefaultMember) {
            if (null != this.mDefaultMemberUN) {
                this.mCachedDefaultMember = (IOlapMember)this.mCachedMeasuresByMUN.get(this.mDefaultMemberUN);
            } else {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_DefaultMemberNotKnown);
            }
        }
        return this.mCachedDefaultMember;
    }

    @Override
    public void setDefaultMemberUN(String defaultMemberUN) {
        this.mCachedDefaultMember = null;
        this.mDefaultMemberUN = defaultMemberUN;
    }

    @Override
    public void setDefaultMember(IOlapMember defaultMember) {
        this.mCachedDefaultMember = defaultMember;
        this.mDefaultMemberUN = defaultMember.getUniqueName();
    }

    @Override
    public IOlapMember getAllMember() {
        if (null == this.mCachedAllMember) {
            if (null != this.mAllMemberUN) {
                this.mCachedAllMember = (IOlapMember)this.mCachedMeasuresByMUN.get(this.mAllMemberUN);
            } else {
                return null;
            }
        }
        return this.mCachedAllMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IOlapMember> getRootMembers() {
        if (null == this.mCachedRootMembers) {
            IQueryLogicalStorage qls = ((AbstractPhysicalModel)this.getModel()).getQLS();
            IProviderManager providerMan = qls.getProviderManager();
            IDataSource dataSource = this.getModel().getDataSource();
            IConnectionSpec connSpec = dataSource.getConnectionSpec();
            String providerType = connSpec.getParameterStringValue("providerType");
            IDimensionalDataProvider provider = (IDimensionalDataProvider)providerMan.getDataProvider(providerType);
            OlapCube cube = (OlapCube)this.getCube();
            Restrictions restrictions = new Restrictions();
            restrictions.put("CATALOG_NAME", cube.getCatalogName());
            restrictions.put("CUBE_NAME", cube.getName());
            restrictions.put("HIERARCHY_UNIQUE_NAME", this.getUniqueName());
            QueryContext queryContext = new QueryContext(LocalSessionContext.get());
            queryContext.setContentLocale(this.getModel().getLocale().toLocale());
            try {
                List records = provider.discoverHierarchyRootMembers(dataSource, (IRestrictions)restrictions, (IQueryContext)queryContext);
                ArrayList<IOlapMeasure> members = new ArrayList<IOlapMeasure>(records.size());
                for (IMemberRecord rec : records) {
                    IOlapMeasure measure = this.mCachedMeasuresByMUN.get(rec.getUniqueName());
                    if (null == measure) {
                        throw new QLSRuntimeException(QLSMessageKeys.MOD_MeasureNotFound, rec.getUniqueName());
                    }
                    members.add(measure);
                }
                this.mCachedRootMembers = members;
            }
            finally {
                queryContext.terminate();
            }
        }
        return this.mCachedRootMembers;
    }
}

