/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.event.EPhysicalModelEventType;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelEventListener;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelWatcher;
import com.ibm.cognos.aurora.api.model.physical.event.PhysicalModelEvent;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.ICubeRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapCube;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class OlapModelWatcher
implements IPhysicalModelWatcher {
    private static final int UPDATE_RETRY_ATTEMPTS = 2;
    private static final int UPDATE_RETRY_DELAY = 500;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.model");
    private final IQueryLogicalStorage mQLS;
    private final IOlapModel mModel;
    private final boolean mAsynchronous;
    private final long mUpdateInterval;
    private Timer mUpdateTimer;
    private final List<IPhysicalModelEventListener> mListeners = new LinkedList<IPhysicalModelEventListener>();
    private volatile boolean mDisposed = false;
    private volatile boolean mDataSourceAvailable = true;
    private volatile Date mLastUpdate;
    private volatile Date mLastDataChange;
    private volatile Date mLastMetadataChange;

    public OlapModelWatcher(IQueryLogicalStorage qls, IOlapModel model, boolean isAsynchronous, long updateInterval) {
        Date now;
        this.mQLS = qls;
        this.mModel = model;
        this.mAsynchronous = isAsynchronous;
        this.mUpdateInterval = updateInterval;
        if (this.mAsynchronous && updateInterval <= 0L) {
            throw new IllegalArgumentException("updateInterval <= 0");
        }
        this.mLastUpdate = now = new Date();
        this.mLastDataChange = now;
        this.mLastMetadataChange = now;
        this.update();
        if (this.mAsynchronous) {
            this.startAsyncWatcher(updateInterval);
        }
    }

    public boolean isAsynchronous() {
        return this.mAsynchronous;
    }

    public IPhysicalModel getModel() {
        return this.mModel;
    }

    public Date getLastUpdate() {
        return this.mLastUpdate;
    }

    public Date getLastDataChange() {
        return this.mLastDataChange;
    }

    public Date getLastMetadataChange() {
        return this.mLastMetadataChange;
    }

    public boolean isDataSourceAvailable(boolean forceUpdate) {
        if (forceUpdate) {
            this.update();
        }
        return this.mDataSourceAvailable;
    }

    public boolean update() {
        if (this.mDisposed) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Updating watcher for model '" + this.mModel.toString() + "'", this.getClass().getName() + "::update()");
        }
        boolean hasUpdates = false;
        this.mLastUpdate = new Date();
        IOlapModel olapModel = this.mModel;
        IDataSource dataSource = olapModel.getDataSource();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        String providerType = connSpec.getParameterStringValue("providerType");
        IDimensionalDataProvider provider = (IDimensionalDataProvider)this.mQLS.getProviderManager().getDataProvider(providerType);
        boolean dataSourceTestPassed = false;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                provider.testDataSource(dataSource);
                dataSourceTestPassed = true;
                break;
            }
            catch (Exception ex) {
                logger.error("Error caught during test of data source '" + dataSource.toString() + "'", this.getClass().getName() + "::update()", (Throwable)ex);
                dataSourceTestPassed = false;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (dataSourceTestPassed) {
            if (!this.mDataSourceAvailable) {
                this.mDataSourceAvailable = true;
                hasUpdates = true;
                if (logger.isWarnEnabled()) {
                    logger.warn("Data source '" + dataSource.toString() + "' became available", this.getClass().getName() + "::update()");
                }
                this.dispatchEvent(new PhysicalModelEvent((IPhysicalModel)this.mModel, EPhysicalModelEventType.DATASOURCE_AVAILABLE, null));
            }
            for (IOlapCube cube : olapModel.getCubes()) {
                hasUpdates |= this.updateCube(provider, dataSource, (OlapCube)cube);
            }
        } else if (this.mDataSourceAvailable) {
            this.mDataSourceAvailable = false;
            hasUpdates = true;
            if (logger.isWarnEnabled()) {
                logger.warn("Data source '" + dataSource.toString() + "' became unavailable", this.getClass().getName() + "::update()");
            }
            this.dispatchEvent(new PhysicalModelEvent((IPhysicalModel)this.mModel, EPhysicalModelEventType.DATASOURCE_UNAVAILABLE, null));
        }
        return hasUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCube(IDimensionalDataProvider provider, IDataSource dataSource, OlapCube cube) {
        boolean hasUpdates = false;
        Restrictions rest = new Restrictions();
        rest.put("CATALOG_NAME", cube.getCatalogName());
        rest.put("CUBE_NAME", cube.getName());
        QueryContext queryContext = new QueryContext(null);
        List records = null;
        try {
            for (int attempt = 0; attempt < 2; ++attempt) {
                try {
                    records = provider.discoverCubes(dataSource, (IRestrictions)rest, (IQueryContext)queryContext);
                    break;
                }
                catch (Exception ex) {
                    logger.error("Exception caught during lookup of cube '" + cube.getName() + "'", this.getClass().getName() + "::updateCube()", (Throwable)ex);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        finally {
            queryContext.terminate();
        }
        if (null == records || records.isEmpty()) {
            return false;
        }
        ICubeRecord cubeRec = (ICubeRecord)records.get(0);
        Date now = new Date();
        Date newLastSchemaUpdate = cubeRec.getLastSchemaUpdate();
        Date newLastDataUpdate = cubeRec.getLastDataUpdate();
        if (newLastSchemaUpdate.compareTo(cube.getLastSchemaUpdate()) > 0) {
            if (logger.isWarnEnabled()) {
                logger.warn("Detected metadata change for cube '" + cubeRec.getCubeName() + "'", this.getClass().getName() + "::updateCube()");
            }
            this.mLastMetadataChange = now;
            hasUpdates = true;
            this.dispatchEvent(new PhysicalModelEvent((IPhysicalModel)this.mModel, EPhysicalModelEventType.METADATA_CHANGE, (IPhysicalMetadata)cube));
        }
        if (newLastDataUpdate.compareTo(cube.getLastDataUpdate()) > 0) {
            if (logger.isWarnEnabled()) {
                logger.warn("Detected data change for cube '" + cubeRec.getCubeName() + "'", this.getClass().getName() + "::updateCube()");
            }
            this.mLastDataChange = now;
            hasUpdates = true;
            this.dispatchEvent(new PhysicalModelEvent((IPhysicalModel)this.mModel, EPhysicalModelEventType.DATA_CHANGE, (IPhysicalMetadata)cube));
        }
        cube.setLastSchemaUpdate(newLastSchemaUpdate);
        cube.setLastDataUpdate(newLastDataUpdate);
        return hasUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(PhysicalModelEvent event) {
        List<IPhysicalModelEventListener> list = this.mListeners;
        synchronized (list) {
            for (IPhysicalModelEventListener l : this.mListeners) {
                l.onEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IPhysicalModelEventListener listener) {
        List<IPhysicalModelEventListener> list = this.mListeners;
        synchronized (list) {
            if (this.mDisposed) {
                throw new IllegalStateException("OlapModelWatcher was disposed");
            }
            this.mListeners.add(listener);
        }
        listener.onConnect((IPhysicalModelWatcher)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IPhysicalModelEventListener listener) {
        boolean removed = false;
        List<IPhysicalModelEventListener> list = this.mListeners;
        synchronized (list) {
            removed = this.mListeners.remove(listener);
        }
        if (removed) {
            listener.onDisconnect((IPhysicalModelWatcher)this);
        }
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        if (this.mAsynchronous) {
            this.stopAsyncWatcher();
        }
        List<IPhysicalModelEventListener> list = this.mListeners;
        synchronized (list) {
            for (IPhysicalModelEventListener l : this.mListeners.toArray(new IPhysicalModelEventListener[0])) {
                this.removeListener(l);
            }
            this.mListeners.clear();
        }
    }

    private void startAsyncWatcher(long updateInterval) {
        if (logger.isInfoEnabled()) {
            logger.info("Starting UpdateTask with " + this.mUpdateInterval + " ms interval for model " + this.mModel.toString(), this.getClass().getName() + "::startAsyncWatcher()");
        }
        this.mUpdateTimer = new Timer("OlapModelWatcher", true);
        this.mUpdateTimer.schedule((TimerTask)new UpdateTask(), this.mUpdateInterval, this.mUpdateInterval);
    }

    private void stopAsyncWatcher() {
        logger.info("Stopping UpdateTask for model " + this.mModel.toString(), this.getClass().getName() + "::stopAsyncWatcher()");
        if (null != this.mUpdateTimer) {
            this.mUpdateTimer.cancel();
        }
    }

    private final class UpdateTask
    extends TimerTask {
        private UpdateTask() {
        }

        @Override
        public void run() {
            OlapModelWatcher.this.update();
        }
    }
}

