/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.rel;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelCrossReference;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelMetadata;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelModel;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.query.provider.tabular.ICrossReferenceRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.rel.AbstractRelMetadata;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public final class RelCrossReference
extends AbstractRelMetadata
implements IRelCrossReference {
    private String mPKName;
    private String mPKColumnInternalUN;
    private IRelColumn mCachedPKColumn;
    private String mFKName;
    private String mFKColumnInternalUN;
    private IRelColumn mCachedFKColumn;
    private short mKeySequenceNumber;

    public RelCrossReference(RelModel model) {
        super(model, (IRelMetadata)null);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.REL_CROSS_REFERENCE;
    }

    public IRelTable getPKTable() {
        return this.getPKColumn().getTable();
    }

    public IRelColumn getPKColumn() {
        if (null == this.mCachedPKColumn && null != this.mPKColumnInternalUN) {
            this.mCachedPKColumn = (IRelColumn)this.getModel().lookupMetadata(this.mPKColumnInternalUN, IRelColumn.class);
            if (null == this.mCachedPKColumn) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_PKColumnNotFound, this.mPKColumnInternalUN);
            }
        }
        return this.mCachedPKColumn;
    }

    public void setPKColumnInternalUN(String pkColumnInternalUN) {
        this.mPKColumnInternalUN = pkColumnInternalUN;
        this.mCachedPKColumn = null;
    }

    public void setPKColumn(IRelColumn pkColumn) {
        this.mPKColumnInternalUN = pkColumn.getInternalUniqueName();
        this.mCachedPKColumn = pkColumn;
    }

    public IRelTable getFKTable() {
        return this.getFKColumn().getTable();
    }

    public IRelColumn getFKColumn() {
        if (null == this.mCachedFKColumn && null != this.mFKColumnInternalUN) {
            this.mCachedFKColumn = (IRelColumn)this.getModel().lookupMetadata(this.mFKColumnInternalUN, IRelColumn.class);
            if (null == this.mCachedFKColumn) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_FKColumnNotFound, this.mFKColumnInternalUN);
            }
        }
        return this.mCachedFKColumn;
    }

    public void setFKColumnInternalUN(String fkColumnInternalUN) {
        this.mFKColumnInternalUN = fkColumnInternalUN;
        this.mCachedFKColumn = null;
    }

    public void setFKColumn(IRelColumn fkColumn) {
        this.mFKColumnInternalUN = fkColumn.getInternalUniqueName();
        this.mCachedFKColumn = fkColumn;
    }

    public short getKeySequenceNumber() {
        return this.mKeySequenceNumber;
    }

    public void setKeySequenceNumber(short keySequenceNumber) {
        this.mKeySequenceNumber = keySequenceNumber;
    }

    public String getFKName() {
        return this.mFKName;
    }

    public void setFKName(String fkName) {
        this.mFKName = fkName;
    }

    public String getPKName() {
        return this.mPKName;
    }

    public void setPKName(String pkName) {
        this.mPKName = pkName;
    }

    public void populateFromRecord(ICrossReferenceRecord record) {
        IRelColumn fkColumn;
        IRelColumn pkColumn;
        this.setInternalName("xref " + record.getPKName() + " => " + record.getFKName());
        this.setPKName(record.getPKName());
        this.setFKName(record.getFKName());
        this.setKeySequenceNumber(record.getKeySequenceNumber());
        IRelTable pkTable = ((IRelModel)this.getModel()).findTable(record.getPKSchemaName(), record.getPKCatalogName(), record.getPKTableName());
        if (null != pkTable) {
            pkColumn = pkTable.findColumn(record.getPKColumnName());
            if (null == pkColumn) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_PKColumnNotFound, record.getPKColumnName());
            }
        } else {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_PKColumnNotFound, record.getPKTableName());
        }
        this.setPKColumn(pkColumn);
        IRelTable fkTable = ((IRelModel)this.getModel()).findTable(record.getFKSchemaName(), record.getFKCatalogName(), record.getFKTableName());
        if (null != fkTable) {
            fkColumn = fkTable.findColumn(record.getFKColumnName());
            if (null == fkColumn) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_FKColumnNotFound, record.getFKColumnName());
            }
        } else {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_FKColumnNotFound, record.getFKTableName());
        }
        this.setFKColumn(fkColumn);
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        if (null != this.mPKName) {
            elem.addElement("pkName").setText(this.mPKName);
        }
        if (null != this.mPKColumnInternalUN) {
            elem.addElement("pkColumnInternalUN").setText(this.mPKColumnInternalUN);
        }
        if (null != this.mFKName) {
            elem.addElement("fkName").setText(this.mFKName);
        }
        if (null != this.mFKColumnInternalUN) {
            elem.addElement("fkColumnInternalUN").setText(this.mFKColumnInternalUN);
        }
        elem.addElement("keySequenceNumber").setText(Short.toString(this.mKeySequenceNumber));
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        Element propElem = elem.element("pkName");
        this.mPKName = null != propElem ? propElem.getText() : null;
        this.mCachedPKColumn = null;
        propElem = elem.element("pkColumnInternalUN");
        this.mPKColumnInternalUN = null != propElem ? propElem.getText() : null;
        propElem = elem.element("fkName");
        this.mFKName = null != propElem ? propElem.getText() : null;
        this.mCachedFKColumn = null;
        propElem = elem.element("fkColumnInternalUN");
        this.mFKColumnInternalUN = null != propElem ? propElem.getText() : null;
        propElem = elem.element("keySequenceNumber");
        this.mKeySequenceNumber = null != propElem ? Short.parseShort(propElem.getText()) : (short)0;
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        if (null != this.mPKName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mPKName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mPKColumnInternalUN) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mPKColumnInternalUN);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mFKName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mFKName);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mFKColumnInternalUN) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mFKColumnInternalUN);
        } else {
            out.writeBoolean(false);
        }
        out.writeShort(this.mKeySequenceNumber);
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mPKName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mCachedFKColumn = null;
        this.mPKColumnInternalUN = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mFKName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mCachedPKColumn = null;
        this.mFKColumnInternalUN = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mKeySequenceNumber = in.readShort();
    }
}

