/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.rel;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelModel;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelPrimaryKey;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.query.provider.tabular.IPrimaryKeyRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.rel.AbstractRelMetadata;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelModel;
import com.ibm.cognos.aurora.qls.model.physical.rel.RelTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public final class RelPrimaryKey
extends AbstractRelMetadata
implements IRelPrimaryKey {
    private String mColumnInternalUN;
    private IRelColumn mCachedColumn;
    private short mKeySequenceNumber = 0;
    private String mPKName;

    public RelPrimaryKey(RelModel model, RelTable table) {
        super(model, table);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.REL_PRIMARY_KEY;
    }

    public IRelTable getTable() {
        return (IRelTable)this.getParent();
    }

    public IRelColumn getColumn() {
        if (null == this.mCachedColumn) {
            this.mCachedColumn = (IRelColumn)this.getModel().lookupMetadata(this.mColumnInternalUN, IRelColumn.class);
            if (null == this.mCachedColumn) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_ColumnNotFound, this.mColumnInternalUN);
            }
        }
        return this.mCachedColumn;
    }

    public void setColumnInternalUN(String columnInternalUN) {
        this.mCachedColumn = null;
        this.mColumnInternalUN = columnInternalUN;
    }

    public void setColumn(IRelColumn column) {
        this.mCachedColumn = column;
        this.mColumnInternalUN = column.getInternalUniqueName();
    }

    public short getKeySequenceNumber() {
        return this.mKeySequenceNumber;
    }

    public void setKeySequenceNumber(short keySequenceNumber) {
        this.mKeySequenceNumber = keySequenceNumber;
    }

    public String getPKName() {
        return this.mPKName;
    }

    public void setPKName(String pkName) {
        this.mPKName = pkName;
    }

    public void populateFromRecord(IPrimaryKeyRecord record) {
        IRelColumn pkColumn;
        this.setInternalName("pk " + record.getPKName());
        this.setPKName(record.getPKName());
        this.setKeySequenceNumber(record.getKeySequenceNumber());
        List tables = ((IRelModel)this.getModel()).findTables(record.getSchemaName(), record.getCatalogName(), record.getTableName());
        if (tables.size() > 0) {
            pkColumn = ((IRelTable)tables.get(0)).findColumn(record.getColumnName());
            if (null == pkColumn) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_PKColumnNotFound, record.getColumnName());
            }
        } else {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_PKColumnNotFound, record.getTableName());
        }
        this.setColumn(pkColumn);
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        if (null != this.mColumnInternalUN) {
            elem.addElement("columnInternalUN").setText(this.mColumnInternalUN);
        }
        elem.addElement("keySequenceNumber").setText(Short.toString(this.mKeySequenceNumber));
        if (null != this.mPKName) {
            elem.addElement("pkName").setText(this.mPKName);
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        this.mCachedColumn = null;
        Element propElem = elem.element("columnInternalUN");
        this.mColumnInternalUN = null != propElem ? propElem.getText() : null;
        propElem = elem.element("keySequenceNumber");
        this.mKeySequenceNumber = null != propElem ? Short.parseShort(propElem.getText()) : (short)0;
        propElem = elem.element("pkName");
        this.mPKName = null != propElem ? propElem.getText() : null;
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        if (null != this.mColumnInternalUN) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mColumnInternalUN);
        } else {
            out.writeBoolean(false);
        }
        out.writeShort(this.mKeySequenceNumber);
        if (null != this.mPKName) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mPKName);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mCachedColumn = null;
        this.mColumnInternalUN = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mKeySequenceNumber = in.readShort();
        this.mPKName = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
    }
}

