/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModelFactory;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.pmta_bridge.IPMTABridge;
import com.ibm.cognos.aurora.api.pmta_bridge.PMTABridgeException;
import com.ibm.cognos.aurora.api.pmta_bridge.PMTABridgeFactory;
import com.ibm.cognos.aurora.api.query.IAsyncQuery;
import com.ibm.cognos.aurora.api.query.IAsyncQueryCallback;
import com.ibm.cognos.aurora.api.query.ICancelManager;
import com.ibm.cognos.aurora.api.query.ICancelable;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.OperationCanceledException;
import com.ibm.cognos.aurora.api.query.data.IResultset;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.connection.IConnectionPoolManager;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.queryspec.IQuerySpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IView;
import com.ibm.cognos.aurora.api.query.queryspec.QuerySpecNodeFactory;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.api.storage.data.ILocalDataRepository;
import com.ibm.cognos.aurora.api.storage.waypoint.IWaypointStorageManager;
import com.ibm.cognos.aurora.api.util.IObservable;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryGraph;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.util.ConfigHelper;
import com.ibm.cognos.aurora.core.util.ObservableResourceTracker;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.GraphBackedAssociativeModel;
import com.ibm.cognos.aurora.qls.model.physical.PhysicalModelFactory;
import com.ibm.cognos.aurora.qls.query.AsyncQuery;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.Session;
import com.ibm.cognos.aurora.qls.query.execution.ViewExecutor;
import com.ibm.cognos.aurora.qls.query.execution.olap.TM1ViewExecutor;
import com.ibm.cognos.aurora.qls.query.execution.relational.PivotViewExecutor;
import com.ibm.cognos.aurora.qls.query.planner.QueryPlanner;
import com.ibm.cognos.aurora.qls.query.provider.ProviderManager;
import com.ibm.cognos.aurora.qls.query.provider.connection.ConnectionPoolManager;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecNodeFactoryImpl;
import com.ibm.cognos.aurora.qls.storage.data.LocalDataRepositoryImpl;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorageManager;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryWaypointStorageManager;
import com.ibm.cognos.aurora.qls.util.WorkerPool;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class QueryLogicalStorageImpl
implements IQueryLogicalStorage {
    private static final long WORKERS_SHUTDOWN_TIMEOUT = 30L;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    private final IPhysicalModelFactory mPhysModelFactory = new PhysicalModelFactory(this);
    private Properties mConfig;
    private IProviderManager mProviderManager;
    private IConnectionPoolManager mConnectionPoolManager;
    private LocalDataRepositoryImpl mLocalDataRepo;
    private AbstractWaypointStorageManager mWaypointStorageMan;
    private QueryPlanner mPlanner;
    private IPMTABridge mPMTABridge;
    private WorkerPool mQueryWorkers;
    private final ObservableResourceTracker<ISession> sessions = new ObservableResourceTracker();

    public void initialize(Properties cfg) {
        PerfLogEvent perfEvent;
        block20: {
            perfEvent = null;
            if (logger.isPerfDebugEnabled()) {
                perfEvent = logger.startPerfDebug(this.getClass().getName(), "initialize", "Starting initialization of QueryLogicalStorageImpl");
            }
            if (logger.isInfoEnabled()) {
                logger.info("Initializing QLS with configuration: " + cfg.toString(), this.getClass().getName() + "::initialize()");
            }
            this.mConfig = cfg;
            if (null == this.mConfig.getProperty("aurora.data_dir")) {
                QueryLogicalStorageImpl.throwConfigurationMissing("aurora.data_dir");
            }
            if (null == this.mConfig.getProperty("aurora.temp_dir")) {
                QueryLogicalStorageImpl.throwConfigurationMissing("aurora.temp_dir");
            }
            this.initializeTempDirectory();
            this.initializeDataDirectory();
            boolean pmtaEnabled = "true".equals(this.mConfig.getProperty("aurora.qls.pmta.enabled"));
            if (pmtaEnabled) {
                if (this.mConfig.containsKey("aurora.qls.pmta.embedded_tm1_dir")) {
                    String path = this.mConfig.getProperty("aurora.qls.pmta.embedded_tm1_dir");
                    if (!new File(path).exists()) {
                        throw new QLSRuntimeException(QLSMessageKeys.CFG_PMTAEmbeddedTM1DirMissing, path);
                    }
                    System.setProperty("embedded.tm1.location", this.mConfig.getProperty("aurora.qls.pmta.embedded_tm1_dir"));
                }
                try {
                    PMTABridgeFactory bridgeFactory = new PMTABridgeFactory();
                    this.mPMTABridge = bridgeFactory.newInstance();
                    if (logger.isInfoEnabled()) {
                        logger.info("PMTA Bridge was loaded", this.getClass().getName() + "::initialize()");
                    }
                    break block20;
                }
                catch (PMTABridgeException ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("PMTA Bridge could not be loaded", this.getClass().getName() + "::initialize()", (Throwable)ex);
                    }
                    break block20;
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("PMTA Bridge is not enabled", this.getClass().getName() + "::initialize()");
            }
        }
        this.mConnectionPoolManager = new ConnectionPoolManager();
        this.mProviderManager = new ProviderManager(this);
        List expectedProviders = ConfigHelper.getList((Properties)this.mConfig, (String)"aurora.qls.providers");
        if (expectedProviders.contains("monetdb")) {
            try {
                this.mProviderManager.registerDataProvider("monetdb", "com.ibm.cognos.aurora.qls.query.provider.relational.monetdb.MonetDBDataProvider", this.mConfig);
            }
            catch (Throwable ex) {
                logger.error("Failed to load MonetDB data provider", this.getClass().getName() + "::initialize()", ex);
            }
        }
        if (expectedProviders.contains("tm1")) {
            try {
                this.mProviderManager.registerDataProvider("tm1", "com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1DataProvider", this.mConfig);
            }
            catch (Throwable ex) {
                logger.error("Failed to load TM1 data provider", this.getClass().getName() + "::initialize()", ex);
            }
        }
        this.mLocalDataRepo = new LocalDataRepositoryImpl(this);
        this.mLocalDataRepo.initialize();
        this.mWaypointStorageMan = new InMemoryWaypointStorageManager(this);
        this.mWaypointStorageMan.initialize();
        this.mPlanner = new QueryPlanner();
        this.mQueryWorkers = new WorkerPool("QLS-QueryWorkers");
        if (logger.isInfoEnabled()) {
            logger.info("QLS was initialized", this.getClass().getName() + "::initialize()");
        }
        logger.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.QLSSERVICE, (Status)Status.SUCCESS));
        if (perfEvent != null) {
            logger.stopPerfDebug(perfEvent, "Finished initialization of QueryLogicalStorageImpl");
        }
    }

    public void terminate() {
        if (logger.isInfoEnabled()) {
            logger.info("Terminating QLS", this.getClass().getName() + "::terminate()");
        }
        try {
            if (null != this.mQueryWorkers) {
                this.mQueryWorkers.shutdown();
                if (!this.mQueryWorkers.awaitTermination(30L, TimeUnit.SECONDS)) {
                    logger.error("Query Worker Pool is taking too long to shutdown cleanly - forcing it!", this.getClass().getName() + "::terminate()");
                    for (Runnable r : this.mQueryWorkers.shutdownNow()) {
                        if (!(r instanceof ICancelable)) continue;
                        ((ICancelable)r).cancel();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("Failed to shutdown Query Worker Pool", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            if (null != this.mPlanner) {
                this.mPlanner.dispose();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to dispose of Query Planner", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            if (null != this.mWaypointStorageMan) {
                this.mWaypointStorageMan.dispose();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to dispose of Waypoint Storage Manager", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            if (null != this.mLocalDataRepo) {
                this.mLocalDataRepo.dispose();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to dispose of Local Data Repository", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            if (null != this.mProviderManager) {
                this.mProviderManager.dispose();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to dispose of Provider Manager", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            if (null != this.mConnectionPoolManager) {
                this.mConnectionPoolManager.shutdown();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to shut down Connection Pool Manager", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            if (null != this.mPMTABridge) {
                this.mPMTABridge.dispose();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to dispose of PMTA Bridge", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        try {
            for (ISession session : this.sessions.getResources()) {
                session.terminate();
            }
            this.sessions.clear();
        }
        catch (Exception ex) {
            logger.error("Failed to dispose of Sessions", this.getClass().getName() + "::terminate()", (Throwable)ex);
        }
        if (logger.isInfoEnabled()) {
            logger.info("QLS was terminated", this.getClass().getName() + "::terminate()");
        }
        logger.auditSystemEvent(LogEventHelper.createStopServiceEvent((ObjectType)ObjectType.QLSSERVICE, (Status)Status.SUCCESS));
    }

    public Properties getConfigurationProperties() {
        return this.mConfig;
    }

    public String getTempDirPath() {
        File baseTempDir = new File(ConfigHelper.getString((Properties)this.mConfig, (String)"aurora.temp_dir"));
        return FilenameUtils.concat((String)baseTempDir.getAbsolutePath(), (String)"aurora/qls");
    }

    public String getDataDirPath() {
        File baseDataDir = new File(ConfigHelper.getString((Properties)this.mConfig, (String)"aurora.data_dir"));
        return FilenameUtils.concat((String)baseDataDir.getAbsolutePath(), (String)"aurora/qls");
    }

    public IConnectionPoolManager getConnectionPoolManager() {
        return this.mConnectionPoolManager;
    }

    public IProviderManager getProviderManager() {
        return this.mProviderManager;
    }

    public IAssociativeModel createModel(IConceptInventory conceptInv) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating model", this.getClass().getName() + "::createModel()");
        }
        InMemoryGraph graph = new InMemoryGraph();
        GraphBackedAssociativeModel model = new GraphBackedAssociativeModel(this, (IGraph)graph);
        model.setConceptInventory(conceptInv);
        return model;
    }

    public IAssociativeModel loadModel(IConceptInventory conceptInv, String path) throws IOException {
        PerfLogEvent event = null;
        if (logger.isPerfDebugEnabled()) {
            event = logger.startPerfDebug(this.getClass().getName(), "loadModel", "Start loading model");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loading Model from " + path, this.getClass().getName() + "::loadModel()");
        }
        InMemoryGraph graph = new InMemoryGraph();
        GraphBackedAssociativeModel model = new GraphBackedAssociativeModel(this, (IGraph)graph);
        model.setConceptInventory(conceptInv);
        model.loadFrom(path);
        if (event != null) {
            logger.stopPerfDebug(event, "Finish loading model");
        }
        return model;
    }

    public ILocalDataRepository getLocalDataRepository() {
        return this.mLocalDataRepo;
    }

    public IWaypointStorageManager getWaypointStorageManager() {
        return this.mWaypointStorageMan;
    }

    public IResultset[] query(IQuerySpecification specification, ISession userSession) {
        return this.queryImpl(specification, userSession, null);
    }

    public IAsyncQuery queryAsync(IQuerySpecification specification, ISession userSession, IAsyncQueryCallback callback) {
        if (null == this.mQueryWorkers || this.mQueryWorkers.isShutdown()) {
            throw new IllegalStateException("Query Worker Pool was shutdown");
        }
        AsyncQuery asyncQuery = new AsyncQuery(this, specification, userSession, callback);
        PerfLogEvent perfEvent = null;
        if (logger.isPerfDebugEnabled()) {
            perfEvent = logger.startPerfDebug(this.getClass().getName(), "queryAsync", "Invoking execute(asyncQuery)", LogAction.CALL);
        }
        this.mQueryWorkers.execute(asyncQuery);
        if (perfEvent != null) {
            logger.stopPerfDebug(perfEvent, "Finshed execute(asyncQuery)", LogAction.RETURN);
        }
        return asyncQuery;
    }

    IResultset[] queryImpl(IQuerySpecification specification, ISession userSession, ICancelManager cancelManager) {
        List views = specification.getViews();
        IResultset[] results = new IResultset[views.size()];
        LocalSessionContext.set((ISession)userSession);
        try {
            for (int i = 0; i < results.length; ++i) {
                if (null != cancelManager && cancelManager.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IView view = (IView)views.get(i);
                IPhysicalModel physicalModel = view.findPhysicalModel();
                if (null == physicalModel) {
                    throw new QLSRuntimeException(QLSMessageKeys.MOD_ReferencedPhysicalModelNotFound);
                }
                IDataSource ds = physicalModel.getDataSource();
                QueryContext queryContext = new QueryContext(userSession, cancelManager);
                try {
                    ViewExecutor executor;
                    switch (ds.getType()) {
                        case DIMENSIONAL: {
                            executor = new TM1ViewExecutor(this, this.mPlanner, specification, queryContext);
                            break;
                        }
                        case RELATIONAL: {
                            executor = new PivotViewExecutor(this, this.mPlanner, specification, queryContext);
                            break;
                        }
                        default: {
                            throw new QLSRuntimeException(QLSMessageKeys.PRV_UnsupportedDatasourceType, ds.getType().name());
                        }
                    }
                    if (logger.isAuditDebugEventEnabled()) {
                        logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFreeTextLogData((String)view.toString())));
                    }
                    PerfLogEvent perfEvent = null;
                    if (logger.isPerfDebugEnabled()) {
                        perfEvent = logger.startPerfDebug(this.getClass().getName(), "queryImpl", "Calling ViewExecutor::execute()", LogAction.CALL);
                    }
                    results[i] = executor.execute(view);
                    if (perfEvent == null) continue;
                    logger.stopPerfDebug(perfEvent, "Returned ViewExecutor::execute()", LogAction.RETURN);
                    continue;
                }
                catch (RuntimeException ex) {
                    queryContext.terminate();
                    throw ex;
                }
            }
        }
        catch (RuntimeException ex) {
            for (IResultset rs : results) {
                if (null == rs) continue;
                rs.dispose();
            }
            throw ex;
        }
        finally {
            LocalSessionContext.set(null);
        }
        return results;
    }

    public QuerySpecNodeFactory createQuerySpecNodeFactory() {
        return new QuerySpecNodeFactoryImpl();
    }

    public IPhysicalModelFactory getPhysicalModelFactory() {
        return this.mPhysModelFactory;
    }

    public boolean isPMTABridgeAvailable() {
        return null != this.mPMTABridge;
    }

    public IPMTABridge getPMTABridge() {
        return this.mPMTABridge;
    }

    private void initializeTempDirectory() {
        File tempDirFile = new File(this.getTempDirPath());
        try {
            FileUtils.forceMkdir((File)tempDirFile);
        }
        catch (IOException ex) {
            logger.error("Failed to initialize temp directory", this.getClass().getName() + "::initializeTempDirectory()");
            throw QLSRuntimeException.wrap(ex);
        }
    }

    private void initializeDataDirectory() {
        File dataDirFile = new File(this.getDataDirPath());
        try {
            FileUtils.forceMkdir((File)dataDirFile);
        }
        catch (IOException ex) {
            logger.error("Failed to initialize data directory", this.getClass().getName() + "::initializeTempDirectory()");
            throw QLSRuntimeException.wrap(ex);
        }
    }

    private static void throwConfigurationMissing(String propertyName) {
        throw new QLSRuntimeException(QLSMessageKeys.CFG_RequiredConfigurationPropertyMissing, propertyName);
    }

    public ISession createSession() {
        Session session = new Session();
        this.sessions.add((IObservable)session);
        return session;
    }

    public ISession createSession(Locale contentLocale, Locale productLocale) {
        Session session = new Session();
        session.setContentLocale(contentLocale);
        session.setProductLocale(productLocale);
        this.sessions.add((IObservable)session);
        return session;
    }

    public String formatValue(IValue v) {
        return v.stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveBinaryData(String blobId, IDataSource dataSource, ISession userSession) {
        String providerType = dataSource.getConnectionSpec().getParameterStringValue("providerType");
        LocalSessionContext.set((ISession)userSession);
        try {
            QueryContext queryContext = new QueryContext(userSession, null);
            IProviderManager providerManager = this.getProviderManager();
            IDimensionalDataProvider dataProvider = (IDimensionalDataProvider)providerManager.getDataProvider(providerType);
            byte[] byArray = dataProvider.getTM1Blob(blobId, dataSource, (IQueryContext)queryContext);
            return byArray;
        }
        finally {
            LocalSessionContext.set(null);
        }
    }
}

