/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query;

import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.util.IObservable;
import com.ibm.cognos.aurora.api.util.IObserver;
import com.ibm.cognos.aurora.api.util.IResourceContainer;
import com.ibm.cognos.aurora.api.util.ResourceContainerSynchronized;
import com.ibm.icu.util.TimeZone;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class Session
implements ISession {
    private List<IObserver<ISession>> mObservers = new LinkedList<IObserver<ISession>>();
    private Locale mContentLocale = null;
    private Locale mProductLocale = null;
    private TimeZone mTimeZone = TimeZone.getDefault();
    private final IResourceContainer resourceContainer;

    public Session() {
        this((IResourceContainer)new ResourceContainerSynchronized());
    }

    public Session(IResourceContainer resourceContainer) {
        this.resourceContainer = resourceContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.notifyObservers();
        List<IObserver<ISession>> list = this.mObservers;
        synchronized (list) {
            this.mObservers.clear();
        }
        this.resourceContainer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(IObserver<ISession> observer) {
        List<IObserver<ISession>> list = this.mObservers;
        synchronized (list) {
            if (!this.mObservers.contains(observer)) {
                this.mObservers.add(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(IObserver<ISession> observer) {
        List<IObserver<ISession>> list = this.mObservers;
        synchronized (list) {
            this.mObservers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers() {
        LinkedList<IObserver<ISession>> observers;
        List<IObserver<ISession>> list = this.mObservers;
        synchronized (list) {
            observers = new LinkedList<IObserver<ISession>>(this.mObservers);
        }
        for (IObserver iObserver : observers) {
            iObserver.update((IObservable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IObserver<ISession>> getObservers() {
        List<IObserver<ISession>> list = this.mObservers;
        synchronized (list) {
            return new LinkedList<IObserver<ISession>>(this.mObservers);
        }
    }

    public Locale getContentLocale() {
        return this.mContentLocale;
    }

    public Locale getProductLocale() {
        return this.mProductLocale;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    void setContentLocale(Locale contentLocale) {
        this.mContentLocale = contentLocale;
    }

    void setProductLocale(Locale productLocale) {
        this.mProductLocale = productLocale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.mTimeZone = timeZone;
    }

    public IResourceContainer getResourceContainer() {
        return this.resourceContainer;
    }
}

