/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.ICalculation;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.IMemberSortSpec;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.data.IAxis;
import com.ibm.cognos.aurora.api.query.data.IAxisIterator;
import com.ibm.cognos.aurora.api.query.data.IAxisValue;
import com.ibm.cognos.aurora.api.query.data.IDataPoint;
import com.ibm.cognos.aurora.api.query.data.IDataPointIterator;
import com.ibm.cognos.aurora.api.query.data.IResultset;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalResultSet;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.ArrayCast;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.data.CellCache;
import com.ibm.cognos.aurora.qls.query.data.DataPoint;
import com.ibm.cognos.aurora.qls.query.data.TupleAxisValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class OLAPResultSet
implements IResultset {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final ILogger LOGGER = LoggerManager.getLogger((String)"ATHENA.core.qls.result");
    private IDimensionalResultSet mDimResultSet;
    private final Map<String, ICalculation> mCalculatedMembersMap;
    private final IAssociativeModel mReferencedModel;
    private final IQueryContext mQueryContext;
    private final int mAxesCount;
    private final List<IAxisIterator> mOpenAxisIterators = new ArrayList<IAxisIterator>();
    private Map<String, IMember>[] mAxisMemberCaches;
    private List<IAxisValue>[] mAxisTupleCaches;
    private long[] mAxisCardinalities;
    private boolean[] mLastAxisTupleSeen;
    private IDataPointIterator mCellIterator;
    private final CellCache mCellCache = new CellCache();
    private boolean mLastCellSeen = false;
    protected long[] mPageSizes;
    private long mCellOrdinalLimit = -1L;
    private final IMember DUMMY_MEMBER = new ResultMember();

    public OLAPResultSet(IDimensionalResultSet resultset, Map<String, ICalculation> calculationsMap, IAssociativeModel model, IQueryContext context, int numQueryAxes) {
        this.mDimResultSet = resultset;
        this.mCalculatedMembersMap = calculationsMap;
        this.mReferencedModel = model;
        this.mQueryContext = context;
        this.mAxesCount = numQueryAxes;
        this.initializeCaches();
        this.computePageSizes();
        this.computeCellOrdinalLimit();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Initialized OLAP Result Set with axis cardinalities %s and pages sizes %s [RESULTSET_ID=%h]", Arrays.toString(this.mAxisCardinalities), Arrays.toString(this.mPageSizes), System.identityHashCode(this)), "OLAPResultSet::OLAPResultSet()");
        }
    }

    public IAxis[] getAxes() {
        throw new QLSRuntimeException(CoreMessageKeys.GEN_MethodNotImplemented, "OLAPResultSet::getAxes()");
    }

    public Iterable<IDataPoint> getDataPoints() {
        return new DataPointIterator();
    }

    public int getAxisCount() {
        return this.mAxesCount;
    }

    public IAxisIterator getAxisIterator(int axisOrdinal) {
        return new OLAPAxisIterator(axisOrdinal);
    }

    public long getAxisCardinality(int axisOrdinal) {
        return this.mAxisCardinalities[axisOrdinal];
    }

    private boolean fillCellCache(long minOrdinal) {
        if (this.mCellOrdinalLimit >= 0L && minOrdinal > this.mCellOrdinalLimit) {
            return false;
        }
        if (this.mCellCache.isOrdinalInRange(minOrdinal)) {
            return true;
        }
        if (this.mLastCellSeen) {
            return false;
        }
        if (null == this.mCellIterator) {
            this.mCellIterator = this.mDimResultSet.getCellIterator();
        }
        while (minOrdinal > this.mCellCache.getLastOrdinal()) {
            if (this.mCellIterator.hasNext()) {
                IDataPoint cell = this.mCellIterator.next();
                if (this.mCellOrdinalLimit >= 0L && cell.getOrdinal() > this.mCellOrdinalLimit) {
                    this.mLastCellSeen = true;
                    this.releaseUnusedResources();
                    return false;
                }
                this.mCellCache.putValue(cell.getOrdinal(), cell.getValue());
                continue;
            }
            this.mLastCellSeen = true;
            this.releaseUnusedResources();
            return false;
        }
        if (!this.mLastCellSeen && !this.mCellIterator.hasNext()) {
            this.mLastCellSeen = true;
            this.releaseUnusedResources();
        }
        return true;
    }

    public IValue getValue(long[] axisPositions) {
        long ordinal = this.computeOrdinalFromCoordinates(axisPositions);
        if (this.fillCellCache(ordinal)) {
            return this.mCellCache.getValue(ordinal);
        }
        return null;
    }

    public String dumpToString() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Disposing OLAP Result Set [RESULTSET_ID=%h]", System.identityHashCode(this)), "OLAPResultSet::dispose()");
        }
        if (null != this.mCellIterator) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Closing provider cell iterator [RESULTSET_ID=%h]", System.identityHashCode(this)), "OLAPResultSet::dispose()");
                }
                this.mCellIterator.close();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), "OLAPResultSet::dispose()", (Throwable)ex);
            }
            finally {
                this.mCellIterator = null;
            }
        }
        for (IAxisIterator axisIter : this.mOpenAxisIterators.toArray(new IAxisIterator[0])) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Closing provider axis iterator [RESULTSET_ID=%h]", System.identityHashCode(this)), "OLAPResultSet::dispose()");
                }
                axisIter.dispose();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), "OLAPResultSet::dispose()", (Throwable)ex);
            }
        }
        this.mOpenAxisIterators.clear();
        if (null != this.mDimResultSet) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Closing provider result set [RESULTSET_ID=%h]", System.identityHashCode(this)), "OLAPResultSet::dispose()");
                }
                this.mDimResultSet.close();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), "OLAPResultSet::dispose()", (Throwable)ex);
            }
            finally {
                this.mDimResultSet = null;
            }
        }
        this.mQueryContext.terminate();
    }

    private void computePageSizes() {
        this.mPageSizes = new long[this.mAxesCount];
        for (int i = this.mAxesCount - 1; i > 0; --i) {
            long otherSetsSize = 1L;
            for (int j = i - 1; j >= 0; --j) {
                otherSetsSize *= this.getAxisCardinality(j);
            }
            this.mPageSizes[i] = otherSetsSize;
        }
    }

    private void computeCellOrdinalLimit() {
        int[] axisLimits = this.mQueryContext.getAxisTupleLimits();
        if (axisLimits != null) {
            long[] lastOffsets = new long[axisLimits.length];
            for (int i = 0; i < axisLimits.length; ++i) {
                long cardinality = this.getAxisCardinality(i);
                if ((long)axisLimits[i] > cardinality) {
                    axisLimits[i] = (int)cardinality;
                }
                lastOffsets[i] = axisLimits[i] - 1;
            }
            this.mCellOrdinalLimit = this.computeOrdinalFromCoordinates(lastOffsets);
        }
    }

    private void initializeCaches() {
        this.mAxisMemberCaches = (Map[])ArrayCast.uncheckedCast((Object[])new HashMap[this.mAxesCount]);
        this.mAxisTupleCaches = (List[])ArrayCast.uncheckedCast((Object[])new List[this.mAxesCount]);
        this.mAxisCardinalities = new long[this.mAxesCount];
        this.mLastAxisTupleSeen = new boolean[this.mAxesCount];
        int[] axisLimits = this.mQueryContext.getAxisTupleLimits();
        for (int i = 0; i < this.mAxesCount; ++i) {
            this.mAxisCardinalities[i] = this.mDimResultSet.getAxisCardinality(i);
            this.mAxisMemberCaches[i] = new HashMap<String, IMember>();
            this.mAxisTupleCaches[i] = null != axisLimits ? new ArrayList<IAxisValue>(axisLimits[i]) : new ArrayList<IAxisValue>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUnusedResources() {
        if (null != this.mCellIterator && this.mLastCellSeen) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("All cells are cached, so closing provider cell iterator [RESULTSET_ID=%h]", System.identityHashCode(this)), "OLAPResultSet::releaseUnusedResources()");
                }
                this.mCellIterator.close();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), "OLAPResultSet::releaseUnusedResources()", (Throwable)ex);
            }
            finally {
                this.mCellIterator = null;
            }
        }
        boolean canReleaseDimResultSet = this.mLastCellSeen;
        for (int i = 0; canReleaseDimResultSet && i < this.mLastAxisTupleSeen.length; ++i) {
            if (this.mLastAxisTupleSeen[i]) continue;
            canReleaseDimResultSet = false;
        }
        if (null != this.mDimResultSet && canReleaseDimResultSet) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("All cells and tuples are cached, so closing provider result set [RESULTSET_ID=%h]", System.identityHashCode(this)), "OLAPResultSet::releaseUnusedResources()");
                }
                this.mDimResultSet.close();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), "OLAPResultSet::releaseUnusedResources()", (Throwable)ex);
            }
            finally {
                this.mDimResultSet = null;
            }
        }
    }

    protected long computeOrdinalFromCoordinates(long[] coords) {
        if (coords == null || coords.length != this.mAxesCount) {
            throw new QLSRuntimeException(QLSMessageKeys.EXE_OffsetIncorrect);
        }
        long ordinal = 0L;
        for (int i = this.mAxesCount - 1; i > 0; --i) {
            this.validateOffset(coords, i);
            ordinal += this.mPageSizes[i] * coords[i];
        }
        this.validateOffset(coords, 0);
        return ordinal += coords[0];
    }

    protected void validateOffset(long[] coords, int axisOrdinal) {
        int[] axisLimits = this.mQueryContext.getAxisTupleLimits();
        long limit = axisLimits != null ? Math.min(this.getAxisCardinality(axisOrdinal), (long)axisLimits[axisOrdinal]) : this.getAxisCardinality(axisOrdinal);
        if (coords[axisOrdinal] < 0L || coords[axisOrdinal] >= limit) {
            throw new QLSRuntimeException(QLSMessageKeys.EXE_OffsetOutOfBounds, String.valueOf(coords[axisOrdinal]), (Object)String.valueOf(axisOrdinal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int numAxes = this.getAxisCount();
        for (int i = 0; i < numAxes; ++i) {
            sb.append(NEWLINE).append("Axis ").append(i).append(NEWLINE);
            IAxisIterator iterator = this.getAxisIterator(i);
            try {
                while (iterator.hasNext()) {
                    IAxisValue value = (IAxisValue)iterator.next();
                    sb.append(value).append(NEWLINE);
                }
                continue;
            }
            finally {
                iterator.dispose();
            }
        }
        sb.append(NEWLINE).append("Data points:").append(NEWLINE);
        for (IDataPoint dataPoint : this.getDataPoints()) {
            sb.append(dataPoint.getOrdinal()).append(": ").append(dataPoint.getValue().getFormattedValue()).append(NEWLINE);
        }
        return sb.toString();
    }

    public IQueryContext getQueryContext() {
        return this.mQueryContext;
    }

    private class ResultMember
    implements IMember {
        private IMemberRecord record;

        private ResultMember() {
        }

        public ResultMember(IMemberRecord memberRecord) {
            this.record = memberRecord;
        }

        public IAssociativeModel getReferencedModel() {
            return OLAPResultSet.this.mReferencedModel;
        }

        public String getUniqueName() {
            return this.record.getUniqueName();
        }

        public String getCaption() {
            return this.record.getCaption();
        }

        public IMember getParentMember() {
            String pun = this.record.getParentUniqueName();
            if (pun == null) {
                return null;
            }
            return OLAPResultSet.this.DUMMY_MEMBER;
        }

        public List<IMember> getChildMembers() {
            throw new UnsupportedOperationException();
        }

        public IHierarchy getHierarchy() {
            return OLAPResultSet.this.mReferencedModel.getHierarchy(OLAPResultSet.this.mQueryContext.getSession(), this.record.getHierarchyUniqueName());
        }

        public IAttribute getAttribute() {
            IHierarchy hierarchy = this.getHierarchy();
            List levels = hierarchy.getLevels();
            if (hierarchy.isValues()) {
                return (IAttribute)levels.get(0);
            }
            return (IAttribute)levels.get(this.getMemberDepth());
        }

        public int getMemberDepth() {
            return this.record.getLevelNumber();
        }

        public long getChildrenCardinality() {
            return this.record.getChildrenCardinality();
        }

        public Comparator<IMember> createComparator(IMemberSortSpec memberSortSpec) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getUniqueName();
        }
    }

    private class DataPointIterator
    implements Iterable<IDataPoint>,
    Iterator<IDataPoint> {
        private final CellCache.Cursor mCursor;
        private long mCurrentOrdinal;

        public DataPointIterator() {
            this.mCursor = OLAPResultSet.this.mCellCache.newCursor();
            this.mCurrentOrdinal = -1L;
        }

        @Override
        public Iterator<IDataPoint> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.mCursor.hasMore()) {
                return true;
            }
            return OLAPResultSet.this.fillCellCache(this.mCurrentOrdinal + 1L);
        }

        @Override
        public IDataPoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mCursor.next();
            DataPoint dataPoint = new DataPoint();
            dataPoint.setOrdinal(this.mCursor.getOrdinal());
            dataPoint.setValue(this.mCursor.getValue());
            this.mCurrentOrdinal = this.mCursor.getOrdinal();
            return dataPoint;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class OLAPAxisIterator
    implements IAxisIterator {
        private final int mAxisOrdinal;
        private com.ibm.cognos.aurora.api.query.provider.dim.IAxisIterator mDimIterator;
        private int mTupleLimit = -1;
        private int mTuplesRead = 0;

        public OLAPAxisIterator(int axisOrdinal) {
            this.mAxisOrdinal = axisOrdinal;
            int[] limits = OLAPResultSet.this.mQueryContext.getAxisTupleLimits();
            if (limits != null) {
                this.mTupleLimit = limits[axisOrdinal];
            }
            OLAPResultSet.this.mOpenAxisIterators.add(this);
        }

        public boolean hasNext() {
            boolean hasNext;
            if (this.mTupleLimit > 0 && this.mTuplesRead >= this.mTupleLimit) {
                return false;
            }
            List tupleCache = OLAPResultSet.this.mAxisTupleCaches[this.mAxisOrdinal];
            if (this.mTuplesRead < tupleCache.size()) {
                return true;
            }
            if (OLAPResultSet.this.mLastAxisTupleSeen[this.mAxisOrdinal]) {
                return false;
            }
            if (null == this.mDimIterator) {
                this.mDimIterator = OLAPResultSet.this.mDimResultSet.getAxisIterator(this.mAxisOrdinal);
            }
            if (!(hasNext = this.mDimIterator.hasNext())) {
                ((OLAPResultSet)OLAPResultSet.this).mLastAxisTupleSeen[this.mAxisOrdinal] = true;
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("All tuples are cached for axis (" + this.mAxisOrdinal + "), so closing provider axis iterator [RESULTSET_ID=%h]", System.identityHashCode(OLAPResultSet.this)), "OLAPResultSet.OLAPAxisIterator::hasNext()");
                    }
                    this.mDimIterator.close();
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage(), "OLAPResultSet.OLAPAxisIterator::hasNext()", (Throwable)ex);
                }
                this.mDimIterator = null;
                OLAPResultSet.this.releaseUnusedResources();
            }
            return hasNext;
        }

        public IAxisValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            List tupleCache = OLAPResultSet.this.mAxisTupleCaches[this.mAxisOrdinal];
            IAxisValue tuple = null;
            if (this.mTuplesRead < tupleCache.size()) {
                tuple = (IAxisValue)tupleCache.get(this.mTuplesRead);
            } else {
                tuple = this.fetchNextTuple();
                tupleCache.add(tuple);
            }
            ++this.mTuplesRead;
            return tuple;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
            OLAPResultSet.this.mOpenAxisIterators.remove(this);
            if (null != this.mDimIterator) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Closing provider axis iterator for axis (" + this.mAxisOrdinal + ") [RESULTSET_ID=%h]", System.identityHashCode(OLAPResultSet.this)), "OLAPResultSet.OLAPAxisIterator::dispose()");
                    }
                    this.mDimIterator.close();
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage(), "OLAPResultSet.OLAPAxisIterator::dispose()", (Throwable)ex);
                }
                this.mDimIterator = null;
            }
        }

        private IAxisValue fetchNextTuple() {
            IMemberRecord[] records = this.mDimIterator.next();
            TupleAxisValue tupleValue = new TupleAxisValue(records.length);
            for (int i = 0; i < records.length; ++i) {
                IMember calc;
                IMember aMember = this.getMemberFromMemberRecord(records[i]);
                if (OLAPResultSet.this.mCalculatedMembersMap != null && !OLAPResultSet.this.mCalculatedMembersMap.isEmpty() && (calc = (IMember)OLAPResultSet.this.mCalculatedMembersMap.get(records[i].getUniqueName())) != null) {
                    aMember = calc;
                }
                tupleValue.setMember(aMember, i);
            }
            return tupleValue;
        }

        private IMember getMemberFromMemberRecord(IMemberRecord memberRecord) {
            String uniqueName;
            Map memberCache = OLAPResultSet.this.mAxisMemberCaches[this.mAxisOrdinal];
            IMember member = (IMember)memberCache.get(uniqueName = memberRecord.getUniqueName());
            if (member != null) {
                return member;
            }
            member = new ResultMember(memberRecord);
            memberCache.put(uniqueName, member);
            return member;
        }
    }
}

