/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.execution.olap;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.IMemberSortSpec;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.data.IResultset;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalResultSet;
import com.ibm.cognos.aurora.api.query.provider.dim.IMDQuery;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.query.queryspec.IQuerySpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IView;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.util.collection.MapCast;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.data.OLAPResultSet;
import com.ibm.cognos.aurora.qls.query.execution.ViewExecutor;
import com.ibm.cognos.aurora.qls.query.planner.QueryPlanner;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXQuery;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TM1ViewExecutor
extends ViewExecutor {
    private IAssociativeModel referencedModel;
    private final Map<String, IMember> memberCache = new HashMap<String, IMember>();
    private final IMember DUMMY_MEMBER = new ResultMember();

    public TM1ViewExecutor(IQueryLogicalStorage qls, QueryPlanner planner, IQuerySpecification query, IQueryContext queryContext) {
        super(qls, planner, query, queryContext);
    }

    @Override
    public IResultset execute(IView view) {
        this.referencedModel = (IAssociativeModel)this.mQuery.getReferencedModels().iterator().next();
        IXQEQueryNode querySpecNode = null;
        try {
            querySpecNode = this.mPlanner.plan(this.referencedModel, this.mQuery);
            String mdxASTTree = querySpecNode.dumpToString();
            StringWriter writer = new StringWriter();
            XQETrace trace = new XQETrace();
            trace.addStream((Writer)writer);
            querySpecNode.dumpFormattedXMLQuery(trace);
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"QuerySpecification", (String)this.mQuery.toString())));
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"MDXQuery", (String)mdxASTTree)));
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"MDQuerySpec", (String)writer.toString())));
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.mQuery.toString(), this.getClass().getName() + ":execute");
                logger.debug(mdxASTTree, this.getClass().getName() + ":execute");
                logger.debug(writer.toString(), this.getClass().getName() + ":execute");
            }
        }
        catch (Exception e) {
            throw QLSRuntimeException.wrap(e);
        }
        if (querySpecNode.getType() != 0) {
            throw new QLSRuntimeException(QLSMessageKeys.EXE_WrongResultType, 0, (Object)querySpecNode.getType());
        }
        MDXQuery mdQuery = (MDXQuery)querySpecNode.getFirstChildByType(2000);
        mdQuery.setMDQuerySpec(true);
        mdQuery.setBluenose(true);
        int numAxes = mdQuery.getChildrenOfType(2002).length;
        String providerType = mdQuery.getProviderType();
        int[] axisLimits = (int[])mdQuery.getPropertyValue("axisTupleLimits");
        this.mQueryContext.setAxisTupleLimits(axisLimits);
        IProviderManager providerManager = this.mQLS.getProviderManager();
        IDimensionalDataProvider dataProvider = (IDimensionalDataProvider)providerManager.getDataProvider(providerType);
        PerfLogEvent executeEvent = null;
        if (logger.isPerfDebugEnabled()) {
            executeEvent = logger.startPerfDebug(this.getClass().getName(), "execute", "Start executing query");
        }
        IDimensionalResultSet dimResultSet = dataProvider.execute((IMDQuery)mdQuery, this.mQueryContext);
        if (executeEvent != null) {
            logger.stopPerfDebug(executeEvent, "Finished executing query");
        }
        PerfLogEvent postProcessingEvent = null;
        if (logger.isPerfDebugEnabled()) {
            postProcessingEvent = logger.startPerfDebug(this.getClass().getName(), "execute", "Start post processing");
        }
        Map uniqueNameToCalculation = MapCast.uncheckedCast((Map)((Map)querySpecNode.getPropertyValue("calculationMappings")));
        OLAPResultSet resultSet = new OLAPResultSet(dimResultSet, uniqueNameToCalculation, this.referencedModel, this.mQueryContext, numAxes);
        if (postProcessingEvent != null) {
            logger.stopPerfDebug(postProcessingEvent, "Finished post processing");
        }
        return resultSet;
    }

    IMember getMemberFromMemberRecord(IMemberRecord memberRecord) {
        String uniqueName = memberRecord.getUniqueName();
        IMember member = this.memberCache.get(uniqueName);
        if (member != null) {
            return member;
        }
        member = new ResultMember(memberRecord);
        this.memberCache.put(uniqueName, member);
        return member;
    }

    private class ResultMember
    implements IMember {
        private IMemberRecord record;

        private ResultMember() {
        }

        public ResultMember(IMemberRecord memberRecord) {
            this.record = memberRecord;
        }

        public IAssociativeModel getReferencedModel() {
            return TM1ViewExecutor.this.referencedModel;
        }

        public String getUniqueName() {
            return this.record.getUniqueName();
        }

        public String getCaption() {
            return this.record.getCaption();
        }

        public IMember getParentMember() {
            String pun = this.record.getParentUniqueName();
            if (pun == null) {
                return null;
            }
            return TM1ViewExecutor.this.DUMMY_MEMBER;
        }

        public List<IMember> getChildMembers() {
            throw new UnsupportedOperationException();
        }

        public IHierarchy getHierarchy() {
            String hun = this.record.getHierarchyUniqueName();
            return TM1ViewExecutor.this.referencedModel.getHierarchy(TM1ViewExecutor.this.mQueryContext.getSession(), hun);
        }

        public IAttribute getAttribute() {
            IHierarchy hierarchy = this.getHierarchy();
            List levels = hierarchy.getLevels();
            if (hierarchy.isValues()) {
                return (IAttribute)levels.get(0);
            }
            return (IAttribute)levels.get(this.getMemberDepth());
        }

        public int getMemberDepth() {
            return this.record.getLevelNumber();
        }

        public long getChildrenCardinality() {
            return this.record.getChildrenCardinality();
        }

        public Comparator<IMember> createComparator(IMemberSortSpec memberSortSpec) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getUniqueName();
        }
    }
}

