/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MDXCellProperties {
    public static final String MDX_CELL_PROPERTIES_NAME = "cellProperties";
    private Set<String> defaultCellProperties = new HashSet<String>();
    private Set<String> mCellProperties = new TreeSet<String>();

    public MDXCellProperties() {
        this.mCellProperties.add("VALUE");
        this.mCellProperties.add("CELL_ORDINAL");
        this.mCellProperties.add("FORMAT_STRING");
        this.mCellProperties.add("TM1FORMAT_STRING");
    }

    public void addCellProperty(String cellProperty) {
        this.mCellProperties.add(cellProperty);
    }

    public void removeCellProperty(String cellProperty) {
        this.mCellProperties.remove(cellProperty);
    }

    public void clearCellProperties() {
        this.mCellProperties.clear();
    }

    public boolean containsCellProperty(String cellProperty) {
        return this.mCellProperties.contains(cellProperty);
    }

    public Set<String> getCellProperties() {
        return this.mCellProperties;
    }

    public int getCellPropertyCount() {
        return this.mCellProperties.size();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> it = this.mCellProperties.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public void writeFormattedText(StringBuilder buffer) {
        if (this.getCellPropertyCount() > 0) {
            buffer.append(" ");
            buffer.append("CELL PROPERTIES");
            buffer.append(" ");
            buffer.append(this.toString());
        }
    }

    public void dumpFormattedXMLQuery(XQETrace trace) {
        if (this.mCellProperties.containsAll(this.defaultCellProperties) && this.mCellProperties.size() > this.defaultCellProperties.size()) {
            for (String propertyNameOrg : this.mCellProperties) {
                trace.beginElement("cellProperty", -1);
                trace.attribute("name", propertyNameOrg);
                trace.endElement();
            }
        }
    }
}

