/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXValueExpression;

public class MDXComparisonOperator
extends AbstractMDXValueExpression {
    protected static final String PROPERTY_OPERATOR_TYPE = "type";
    public static final int COMP_OP_EQ = 1;
    public static final int COMP_OP_NEQ = 2;
    public static final int COMP_OP_GT = 3;
    public static final int COMP_OP_LT = 4;
    public static final int COMP_OP_LEQ = 5;
    public static final int COMP_OP_GEQ = 6;
    public static final int COMP_OP_STARTSWITH = 7;
    public static final int COMP_OP_ENDSWITH = 8;
    public static final int COMP_OP_CONTAINS = 9;

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getOperatorTypeString(), -1);
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    private String getOperatorTypeString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "eq";
                break;
            }
            case 2: {
                operatorTypeString = "neq";
                break;
            }
            case 3: {
                operatorTypeString = "gt";
                break;
            }
            case 4: {
                operatorTypeString = "lt";
                break;
            }
            case 6: {
                operatorTypeString = "geq";
                break;
            }
            case 5: {
                operatorTypeString = "leq";
                break;
            }
            case 7: {
                operatorTypeString = "startsWith";
                break;
            }
            case 8: {
                operatorTypeString = "endsWith";
                break;
            }
            case 9: {
                operatorTypeString = "contains";
                break;
            }
        }
        return operatorTypeString;
    }

    public int getOperatorType() {
        return (Integer)this.getPropertyValue(PROPERTY_OPERATOR_TYPE);
    }

    public void setOperatorType(int type) {
        if (type < 1 || type > 9) {
            throw new IllegalStateException("Invalid operand in call to MDXComparisonOperator.setOperatorType().");
        }
        this.setPropertyValue(PROPERTY_OPERATOR_TYPE, type);
    }

    @Override
    public int getType() {
        return 2038;
    }
}

