/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXDimensionProperties;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.OLAPQueryNode;
import java.util.Iterator;

public class MDXEdge
extends OLAPQueryNode {
    public static final String PROP_NON_EMPTY = "nonEmpty";

    public MDXEdge() {
        this.setPropertyValue("dimensionProperties", new MDXDimensionProperties());
    }

    public int getType() {
        return 2002;
    }

    public boolean isOfCategory(int category) {
        if (category == 2002) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setMDXNonEmptyProperty(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_NON_EMPTY, Boolean.TRUE);
        } else {
            this.removeProperty(PROP_NON_EMPTY);
        }
    }

    public boolean getMDXNonEmptyProperty() {
        return this.getPropertyValue(PROP_NON_EMPTY) == Boolean.TRUE;
    }

    public MDXDimensionProperties getDimensionProperties() {
        return (MDXDimensionProperties)this.getPropertyValue("dimensionProperties");
    }

    public void addMemberProperty(String memberProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getDimensionProperties().addMemberProperty(memberProperty);
    }

    public boolean hasMemberProperty(String memberProperty) {
        return this.getDimensionProperties().containsMemberProperty(memberProperty);
    }

    public void replaceMemberProperty(String oldMemberProperty, String newMemberProperty) {
        this.removeMemberProperty(oldMemberProperty);
        this.addMemberProperty(newMemberProperty);
    }

    public void removeMemberProperty(String memberProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getDimensionProperties().removeMemberProperty(memberProperty);
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("edge", -1);
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            ((IXQEQueryNode)childIterator.next()).dumpFormattedXMLQuery(trace);
        }
        this.getDimensionProperties().dumpFormattedXMLQuery(trace);
        if (this.getMDXNonEmptyProperty()) {
            trace.beginElement("suppress", -1);
            trace.beginElement("suppressNulls", -1);
            trace.endElement();
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.getMDXNonEmptyProperty()) {
            buffer.append("NON EMPTY");
            buffer.append(" ");
        }
        this.getChild(0).writeFormattedText(buffer);
        this.getDimensionProperties().writeFormattedText(buffer);
        buffer.append(" ");
        buffer.append("ON AXIS");
        buffer.append("(");
        buffer.append(this.getMDXAxisNumber());
        buffer.append(")");
    }

    private int getMDXAxisNumber() {
        int axisNumber = -1;
        IXQEQueryNode parent = this.getParent();
        if (parent != null) {
            IXQEQueryNode[] children = parent.getChildrenOfTypeOrdered(this.getType());
            for (int idx = 0; idx < children.length && axisNumber == -1; ++idx) {
                if (children[idx] != this) continue;
                axisNumber = idx;
            }
        }
        if (axisNumber == -1) {
            axisNumber = 0;
        }
        return axisNumber;
    }

    public int getMinimumNumberChildren() {
        return 0;
    }

    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = index == 0 ? new int[]{2003} : new int[]{};
        return categories;
    }

    public String[] getSyntaxProperties() {
        return new String[]{"dimensionProperties", PROP_NON_EMPTY};
    }

    public boolean validateChildCategories() {
        IXQEQueryNode parent;
        return super.validateChildCategories() && ((parent = this.getParent()) == null || parent.getType() == 2000);
    }
}

