/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.olap;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.AbstractMDXSetOperator;
import java.util.Iterator;

public class MDXTopBottomFunction
extends AbstractMDXSetOperator {
    protected static final String PROPERTY_FUNCTION_TYPE = "functionType";
    protected static final String PROPERTY_FUNCTION_NAME = "functionName";
    public static final int TOPCOUNT = 1;
    public static final int TOPSUM = 2;
    public static final int TOPPERCENT = 3;
    public static final int BOTTOMCOUNT = 4;
    public static final int BOTTOMSUM = 5;
    public static final int BOTTOMPERCENT = 6;

    @Override
    public int getType() {
        return 2030;
    }

    public int getOperatorType() {
        return (Integer)this.getPropertyValue(PROPERTY_FUNCTION_TYPE);
    }

    public void setOperatorType(int type) {
        this.setPropertyValue(PROPERTY_FUNCTION_TYPE, XQEIntegerPool.getInteger((int)type));
    }

    public void setOperatorType(String mdxFunctionName) {
        int operatorType = -1;
        if (mdxFunctionName.equals("TOPCOUNT")) {
            operatorType = 1;
        } else if (mdxFunctionName.equals("TOPSUM")) {
            operatorType = 2;
        } else if (mdxFunctionName.equals("TOPPERCENT")) {
            operatorType = 3;
        } else if (mdxFunctionName.equals("BOTTOMCOUNT")) {
            operatorType = 4;
        } else if (mdxFunctionName.equals("BOTTOMSUM")) {
            operatorType = 5;
        } else if (mdxFunctionName.equals("BOTTOMPERCENT")) {
            operatorType = 6;
        } else {
            this.throwInternalError("Invalid operator type.");
        }
        this.setPropertyValue(PROPERTY_FUNCTION_TYPE, XQEIntegerPool.getInteger((int)operatorType));
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getOperatorTypeString(), -1);
        trace.endElement();
        Iterator childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            ((IXQEQueryNode)childIterator.next()).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    private String getMDXString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "TOPCOUNT";
                break;
            }
            case 2: {
                operatorTypeString = "TOPSUM";
                break;
            }
            case 3: {
                operatorTypeString = "TOPPERCENT";
                break;
            }
            case 4: {
                operatorTypeString = "BOTTOMCOUNT";
                break;
            }
            case 5: {
                operatorTypeString = "BOTTOMSUM";
                break;
            }
            case 6: {
                operatorTypeString = "BOTTOMPERCENT";
                break;
            }
        }
        return operatorTypeString;
    }

    private String getOperatorTypeString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "topCountSet";
                break;
            }
            case 2: {
                operatorTypeString = "topSumSet";
                break;
            }
            case 3: {
                operatorTypeString = "topPercentSet";
                break;
            }
            case 4: {
                operatorTypeString = "bottomCountSet";
                break;
            }
            case 5: {
                operatorTypeString = "bottomSumSet";
                break;
            }
            case 6: {
                operatorTypeString = "bottomPercentSet";
                break;
            }
        }
        return operatorTypeString;
    }

    public String getMDXTextName() {
        return this.getMDXString();
    }
}

