/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.EOperator;
import com.ibm.cognos.aurora.qls.query.execution.relational.SQLEmitter;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAbstractFunction;

public class SQLComparison
extends SQLAbstractFunction {
    public static final String PROP_ENUM_SUBTYPE = "subType";

    public int getType() {
        return 3005;
    }

    @Override
    public void accept(SQLEmitter visitor) {
        visitor.visit(this);
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    public void setSubType(EOperator operator) {
        switch (operator) {
            case EQUALS: {
                this.setSubType(SubType.EQUAL);
                break;
            }
            case NOT_EQUALS: {
                this.setSubType(SubType.NOTEQUAL);
                break;
            }
            case LESS_THAN: {
                this.setSubType(SubType.LESS);
                break;
            }
            case GREATER_THAN: {
                this.setSubType(SubType.GREATER);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                this.setSubType(SubType.LESSEQUAL);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                this.setSubType(SubType.GREATEREQUAL);
                break;
            }
        }
    }

    @Override
    public String getFunctionName() {
        return this.getSubType().key();
    }

    @Override
    public String getPattern() {
        return this.getSubType().getPattern();
    }

    public static enum SubType {
        LESS("LessThan", "%s < %s"),
        LESSEQUAL("LessThanOrEquals", "%s <= %s"),
        EQUAL("Equals", "%s = %s"),
        NOTEQUAL("NotEquals", "%s <> %s"),
        GREATEREQUAL("GreaterThanOrEquals", "%s >= %s"),
        GREATER("GreaterThan", "%s > %s");

        private String key;
        private String pattern;

        private SubType(String theKey, String thePattern) {
            this.key = theKey;
            this.pattern = thePattern;
        }

        public String key() {
            return this.key;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

