/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.ast.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.EFunction;
import com.ibm.cognos.aurora.qls.query.execution.relational.SQLEmitter;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAbstractFunction;

public class SQLFunction
extends SQLAbstractFunction {
    private static final String PROP_ENUM_SUBTYPE = "subType";

    @Override
    public void accept(SQLEmitter visitor) {
        visitor.visit(this);
    }

    public int getType() {
        return 3010;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    public void setSubType(SubType subType, String name) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
        this.setFunctionName(name);
    }

    public void setSubType(EFunction function) {
        switch (function) {
            case ADD_DAYS: {
                this.setSubType(SubType.ADD_DAYS);
                break;
            }
            case ADD_MONTHS: {
                this.setSubType(SubType.ADD_MONTHS);
                break;
            }
            case ADD_YEARS: {
                this.setSubType(SubType.ADD_YEARS);
                break;
            }
            case CURRENT_DATE: {
                this.setSubType(SubType.CURRENT_DATE);
                break;
            }
            case CURRENT_TIME: {
                this.setSubType(SubType.CURRENT_TIME);
                break;
            }
            case CURRENT_TIMESTAMP: {
                this.setSubType(SubType.CURRENT_TIMESTAMP);
                break;
            }
            case DAY_OF_YEAR: {
                this.setSubType(SubType.DAY_OF_YEAR);
                break;
            }
            case SUBTRACT_DAYS: {
                this.setSubType(SubType.SUBTRACT_DAYS);
                break;
            }
            case SUBTRACT_MONTHS: {
                this.setSubType(SubType.SUBTRACT_MONTHS);
                break;
            }
            case SUBTRACT_YEARS: {
                this.setSubType(SubType.SUBTRACT_YEARS);
                break;
            }
            case YEAR: {
                this.setSubType(SubType.YEAR);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String getFunctionName() {
        SubType subType = this.getSubType();
        if (subType == SubType.UDF || subType == SubType.MACRO) {
            return super.getFunctionName();
        }
        return subType.key();
    }

    @Override
    public String getPattern() {
        switch (this.getSubType()) {
            case CURRENT_DATE: {
                return "CURRENT_DATE";
            }
            case CURRENT_TIME: {
                return "CURRENT_TIME";
            }
            case CURRENT_TIMESTAMP: {
                return "CURRENT_TIMESTAMP";
            }
            case ADD_DAYS: {
                return "%s + CAST(%s AS INTERVAL DAY)";
            }
            case ADD_MONTHS: {
                return "%s + CAST(%s AS INTERVAL MONTH)";
            }
            case ADD_YEARS: {
                return "%s + CAST(%s AS INTERVAL YEAR)";
            }
            case SUBTRACT_DAYS: {
                return "%s - CAST(%s AS INTERVAL DAY)";
            }
            case SUBTRACT_MONTHS: {
                return "%s - CAST(%s AS INTERVAL MONTH)";
            }
            case SUBTRACT_YEARS: {
                return "%s - CAST(%s AS INTERVAL YEAR)";
            }
            case DAY_OF_WEEK: {
                return "DAYOFWEEK(%s)";
            }
            case DAY_OF_MONTH: {
                return "DAYOFMONTH(%s)";
            }
            case DAY_OF_YEAR: {
                return "DAYOFYEAR(%s)";
            }
            case WEEK_OF_YEAR: {
                return "WEEKOFYEAR(%s)";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM %s)";
            }
            case MONTH: {
                return "EXTRACT(MONTH FROM %s)";
            }
            case DAY: {
                return "EXTRACT(DAY FROM %s)";
            }
            case HOUR: {
                return "EXTRACT(HOUR FROM %s)";
            }
            case MINUTE: {
                return "EXTRACT(MINUTE FROM %s)";
            }
            case SECOND: {
                return "EXTRACT(SECOND FROM %s)";
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum SubType {
        UDF(null),
        MACRO(null),
        UPPER("Upper"),
        LOWER("Lower"),
        SUBSTRING("Substring"),
        REVERSE("Reverse"),
        TRANSLATE("Translate"),
        POSITION("Position"),
        INDEX("Index"),
        CHAR_LENGTH("CharLength"),
        OCTET_LENGTH("OctetLength"),
        BIT_LENGTH("BitLength"),
        ROUND("Round"),
        ASCII("Ascii"),
        ABS("Abs"),
        MOD("Mod"),
        SAFE_MOD("SafeMod"),
        LN("Ln"),
        LOG10("Log10"),
        EXP("Exp"),
        POWER("Power"),
        SQRT("Sqrt"),
        FLOOR("Floor"),
        CEILING("Ceiling"),
        WIDTH_BUCKET("WidthBucket"),
        CURRENT_DATE("CurrentDate"),
        CURRENT_TIME("CurrentTime"),
        CURRENT_TIMESTAMP("CurrentTimestamp"),
        LOCALTIME("LocalTime"),
        LOCALTIMESTAMP("LocalTimestamp"),
        ADD_DAYS("AddDays"),
        ADD_MONTHS("AddMonths"),
        ADD_YEARS("AddYears"),
        SUBTRACT_DAYS("SubtractDays"),
        SUBTRACT_MONTHS("SubtractMonths"),
        SUBTRACT_YEARS("SubtractYears"),
        AGE("Age"),
        DAY_OF_WEEK("DayOfWeek"),
        DAY_OF_MONTH("DayOfMonth"),
        DAY_OF_YEAR("DayOfYear"),
        DAYS_BETWEEN("DaysBetween"),
        DAYS_TO_END_OF_MONTH("DaysToEndOfMonth"),
        FIRST_OF_MONTH("FirstOfMonth"),
        LAST_OF_MONTH("LastOfMonth"),
        MAKE_TIMESTAMP("MakeTimestamp"),
        MONTHS_BETWEEN("MonthsBetween"),
        WEEK_OF_YEAR("WeekOfYear"),
        YEARS_BETWEEN("YearsBetween"),
        YEAR("YearsBetween"),
        MONTH("YearsBetween"),
        DAY("YearsBetween"),
        HOUR("YearsBetween"),
        MINUTE("YearsBetween"),
        SECOND("YearsBetween"),
        ACOS("Arccos"),
        ASIN("Arcsin"),
        ATAN("Arctan"),
        COS("Cos"),
        COSH("Coshyp"),
        SIN("Sin"),
        SINH("Sinhyp"),
        TAN("Tan"),
        TANH("Tanhyp");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        String key() {
            return this.key;
        }
    }
}

