/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules;

import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.query.queryspec.IView;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.BoundPhysicalModel;

public class BindPhysicalModel
extends AbstractRule {
    public BindPhysicalModel() {
        this.mName = "Bind physical model.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode boundModelNode = node.getFirstChildByType(24);
        if (null == boundModelNode) {
            this.traceNodeCondition(true, "Physical model needs to be bound.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Physical model was already bound.", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IView view = (IView)node;
        IPhysicalModel model = view.findPhysicalModel();
        if (null == model) {
            throw new QLSRuntimeException(QLSMessageKeys.QSP_NoPhysicalModelInViewSpec);
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        BoundPhysicalModel boundModelNode = (BoundPhysicalModel)nodeFactory.createNode(24);
        boundModelNode.bindPhysicalModel(model);
        node.addChild((IXQEQueryNode)boundModelNode);
    }
}

