/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.exception.LocalizedRuntimeException;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IContext;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTuple;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import java.util.ArrayList;

public abstract class ContextDependentRule
extends OLAPQueryRule {
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ContextDependentRule.hasOLAPDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
            return false;
        }
        if (!node.isOfCategory(31)) {
            this.traceNodeCondition(false, "Node is not of category \"Context\".", trace);
            return false;
        }
        IContext contextNode = (IContext)node;
        this.validateContext(node, contextNode.getContext(), this.getSpec(node).getDescendantsOfType(4, false));
        return true;
    }

    protected MDXTuple constructContextTuple(IXQEQueryNode node, XQENodeFactory nodeFactory) {
        String defaultMeasureUN;
        IMember[] context = null;
        IContext contextNode = null;
        if (node instanceof IContext) {
            contextNode = (IContext)node;
            context = contextNode.getContext();
        }
        MDXTuple mdxTuple = (MDXTuple)nodeFactory.createNode(2023, node);
        if (context == null) {
            throw new IllegalStateException();
        }
        for (IMember member : context) {
            String mun = member.getUniqueName();
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(mun);
            baseMember.setMeasure(member.getHierarchy().isValues());
            mdxTuple.addChild(baseMember);
        }
        if (contextNode != null && (defaultMeasureUN = contextNode.getDefaultMeasureUniqueName()) != null) {
            BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
            baseMember.setMemberUniqueName(defaultMeasureUN);
            baseMember.setMeasure(true);
            mdxTuple.addChild(baseMember);
        }
        return mdxTuple;
    }

    protected void validateContext(IXQEQueryNode node, IMember[] members, IXQEQueryNode[] selectionNodes) {
        ArrayList<IHierarchy> hierarchiesInContext = new ArrayList<IHierarchy>();
        for (IMember iMember : members) {
            IHierarchy memberHierarchy = iMember.getHierarchy();
            if (hierarchiesInContext.contains(memberHierarchy)) {
                throw new QLSRuntimeException(QLSMessageKeys.QSP_MultipleMembersSameHierarchyInContext, node.getNodeTypeName(), (Object)memberHierarchy.getUniqueName());
            }
            hierarchiesInContext.add(memberHierarchy);
        }
        for (IMember iMember : selectionNodes) {
            if (iMember.getType() != 4) {
                throw new LocalizedRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
            }
            ISelectionSpecification selectionNode = (ISelectionSpecification)iMember;
            if (!hierarchiesInContext.contains(selectionNode.getHierarchy())) continue;
            throw new QLSRuntimeException(QLSMessageKeys.QSP_MultipleMembersSameHierarchyInContext, node.getNodeTypeName(), (Object)selectionNode.getHierarchy().getUniqueName());
        }
    }
}

