/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTuple;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisSpecification;

public class ConvertAxisToMDXEdge
extends OLAPQueryRule {
    public ConvertAxisToMDXEdge() {
        this.mName = "Convert a QuerySpec Axis to a MDX edge.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{2};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 2) {
            if (!ConvertAxisToMDXEdge.hasOLAPDataSource(node)) {
                this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
                return false;
            }
            this.traceNodeCondition(true, "AxisSpecification needs to be converted to a MDXEdge.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Node is not of type AxisSpecification", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IMember[][] suppressedTuples;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxEdgeNode = nodeFactory.createNode(2002, node);
        AxisSpecification axisSpec = (AxisSpecification)node;
        Boolean suppressMissing = (Boolean)axisSpec.getOption(IAxisSpecification.AxisOption.SUPPRESS_MISSING);
        if (suppressMissing != null && suppressMissing.booleanValue()) {
            mdxEdgeNode.setPropertyValue("nonEmpty", (Object)suppressMissing);
        }
        if ((suppressedTuples = (IMember[][])axisSpec.getOption(IAxisSpecification.AxisOption.SUPPRESS_TUPLES)) != null) {
            IXQEQueryNode exceptFunction = nodeFactory.createNode(2047);
            node.exchange(exceptFunction, true);
            IXQEQueryNode exceptSet = nodeFactory.createNode(2004);
            exceptFunction.addChild(exceptSet);
            for (IMember[] tuple : suppressedTuples) {
                MDXTuple mdxTuple = (MDXTuple)nodeFactory.createNode(2023, node);
                for (IMember member : tuple) {
                    String mun = member.getUniqueName();
                    BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
                    baseMember.setMemberUniqueName(mun);
                    baseMember.setMeasure(member.getHierarchy().isValues());
                    mdxTuple.addChild(baseMember);
                }
                exceptSet.addChild((IXQEQueryNode)mdxTuple);
            }
            exceptFunction.insertParent(mdxEdgeNode);
        } else {
            node.exchange(mdxEdgeNode, true);
        }
    }
}

