/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseHierarchy;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseLevel;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXLevels;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionCategory;

public class ConvertCategoryToMDXLevel
extends OLAPQueryRule {
    public ConvertCategoryToMDXLevel() {
        this.mName = "Convert a Category selection to a MDX Level.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{6};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 6) {
            if (!ConvertCategoryToMDXLevel.hasOLAPDataSource(node)) {
                this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
                return false;
            }
            this.traceNodeCondition(true, "Category selection needs to be converted to a BaseLevel.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Node is not of type Category selection", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionActionCategory selectCategory = (SelectionActionCategory)node;
        INode category = selectCategory.getCategory();
        IDataItem dataItem = NavigationHelper.getIdentifierAttributeFromCategory((INode)category).getDataItem();
        IOlapLevel levelMetadata = (IOlapLevel)dataItem.getPhysicalMetadata();
        IOlapHierarchy hierarchyMetadata = levelMetadata.getHierarchy();
        if (hierarchyMetadata.isParentChild()) {
            MDXLevels mdxLevelsNode = (MDXLevels)nodeFactory.createNode(2009, node);
            BaseHierarchy baseHierNode = (BaseHierarchy)nodeFactory.createNode(2012, (IXQEQueryNode)mdxLevelsNode);
            baseHierNode.setHierarchyUniqueName(hierarchyMetadata.getUniqueName());
            MDXNumericConstant depthConstNode = (MDXNumericConstant)nodeFactory.createNode(2015, (IXQEQueryNode)mdxLevelsNode);
            depthConstNode.setConstantValue(levelMetadata.getLevelNumber());
            mdxLevelsNode.addChild(baseHierNode);
            mdxLevelsNode.addChild(depthConstNode);
            node.exchange((IXQEQueryNode)mdxLevelsNode, true);
        } else {
            BaseLevel baseLevelNode = (BaseLevel)nodeFactory.createNode(2008, node);
            String lun = levelMetadata.getUniqueName();
            baseLevelNode.setLevelUniqueName(lun);
            node.exchange((IXQEQueryNode)baseLevelNode, true);
        }
    }
}

