/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.ECountType;
import com.ibm.cognos.aurora.api.model.EDirectionType;
import com.ibm.cognos.aurora.api.model.ETiesType;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IFilterByData;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXNumericConstant;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXTopBottomFunction;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.ContextDependentRule;
import com.ibm.cognos.aurora.qls.query.queryspec.FilterByData;

public class ConvertFilterByDataTopBottomCalculation
extends ContextDependentRule {
    public ConvertFilterByDataTopBottomCalculation() {
        this.mName = "Replace FilterByData with the top/bottom count function.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{30};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        IFilterByData filterByData = (IFilterByData)node;
        if (filterByData.getDirection() == null) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalError);
        }
        if (filterByData.getTiesType() == ETiesType.Exclude || filterByData.getTiesType() == ETiesType.Include) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_NotYetSupported, filterByData.getTiesType().toString());
        }
        this.traceNodeCondition(true, "The FilterByData set action needs to be converted to an MDX Filter.", environment.getTrace());
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        FilterByData filterByDataNode = (FilterByData)node;
        EDirectionType direction = filterByDataNode.getDirection();
        ECountType countType = filterByDataNode.getCountType();
        MDXTopBottomFunction mdxTopBottom = (MDXTopBottomFunction)nodeFactory.createNode(2030);
        block0 : switch (direction) {
            case Top: {
                switch (countType) {
                    case Number: {
                        mdxTopBottom.setOperatorType(1);
                        break block0;
                    }
                    case Percentage: {
                        mdxTopBottom.setOperatorType(3);
                        break block0;
                    }
                    case Cumulative: {
                        mdxTopBottom.setOperatorType(2);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case Bottom: {
                switch (countType) {
                    case Number: {
                        mdxTopBottom.setOperatorType(4);
                        break block0;
                    }
                    case Percentage: {
                        mdxTopBottom.setOperatorType(6);
                        break block0;
                    }
                    case Cumulative: {
                        mdxTopBottom.setOperatorType(5);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        MDXNumericConstant countConstant = (MDXNumericConstant)nodeFactory.createNode(2015);
        countConstant.setConstantValue(filterByDataNode.getCount());
        IXQEQueryNode mdxIntersect = nodeFactory.createNode(2048);
        IXQEQueryNode setSpecification = this.getSpec((IXQEQueryNode)filterByDataNode);
        for (IXQEQueryNode specificationNode : setSpecification.getChildren()) {
            if (specificationNode == filterByDataNode) continue;
            IXQEQueryNode copy = nodeFactory.deepCopyNode(specificationNode);
            mdxIntersect.addChild(copy);
        }
        this.wrapSetsOrSelections((IXQEQueryNode)filterByDataNode, mdxTopBottom, nodeFactory);
        mdxTopBottom.addChild(countConstant, 1);
        mdxTopBottom.addChild(this.constructContextTuple((IXQEQueryNode)filterByDataNode, nodeFactory), 2);
        mdxTopBottom.insertParent(mdxIntersect);
    }
}

