/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.olap;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMeasure;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMemberProperty;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.BaseMember;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberDefinition;
import com.ibm.cognos.aurora.qls.query.planner.ast.olap.MDXCalculatedMemberReference;
import com.ibm.cognos.aurora.qls.query.planner.rules.olap.OLAPQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionMetrics;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionNodes;
import java.util.List;

@Deprecated
public class ConvertMetricToMDXMeasure
extends OLAPQueryRule {
    public ConvertMetricToMDXMeasure() {
        this.mName = "Convert a Metric selection to a MDX Measure.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{5};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 5) {
            if (!ConvertMetricToMDXMeasure.hasOLAPDataSource(node)) {
                this.traceNodeCondition(false, "Node is not associated with an OLAP data source.", trace);
                return false;
            }
            this.traceNodeCondition(true, "Metric selection needs to be converted to a BaseMeasure.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Node is not of type Metric selection", trace);
        return false;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SelectionActionMetrics selectMetric = (SelectionActionMetrics)node;
        INode[] metrics = selectMetric.getMetrics();
        IXQEQueryNode parent = node.getParent();
        IXQEQueryNode mdxQuery = node.getAncestorOfType(2000);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (INode metric : metrics) {
            INode category;
            if (metric.isMetric()) {
                IOlapMeasure measureMetadata = (IOlapMeasure)metric.getDataItem().getPhysicalMetadata();
                String mun = measureMetadata.getUniqueName();
                BaseMember baseMember = (BaseMember)nodeFactory.createNode(2010, node);
                baseMember.setMemberUniqueName(mun);
                baseMember.setMeasure(true);
                parent.addChild((IXQEQueryNode)baseMember);
                continue;
            }
            INode attribute = metric;
            if (attribute.isCategory()) {
                category = attribute;
                attribute = NavigationHelper.getDefaultAttributeNode((INode)attribute);
            } else {
                category = NavigationHelper.getCategoryFromAttribute((INode)attribute);
            }
            MDXCalculatedMemberDefinition calcMemberDef = (MDXCalculatedMemberDefinition)nodeFactory.createNode(2027);
            MDXCalculatedMemberReference calcMemberRef = (MDXCalculatedMemberReference)nodeFactory.createNode(2028);
            calcMemberRef.bind(calcMemberDef);
            mdxQuery.addChild((IXQEQueryNode)calcMemberDef, 0);
            IDataItem dataItem = attribute.getDataItem();
            IOlapMemberProperty memberProp = (IOlapMemberProperty)dataItem.getPhysicalMetadata();
            IOlapCube cube = memberProp.getCube();
            IOlapHierarchy hierarchy = null;
            List dimensions = cube.getDimensions();
            for (IOlapDimension dimension : dimensions) {
                if (!dimension.isMeasureDimension()) continue;
                hierarchy = dimension.getDefaultHierarchy();
            }
            calcMemberDef.setHierarchy(hierarchy);
            calcMemberDef.setPrefix("");
            calcMemberDef.generateUniqueName();
            calcMemberDef.addChild(this.createCategoryCount(category, nodeFactory));
            parent.addChild((IXQEQueryNode)calcMemberRef);
        }
        node.detach();
    }

    private IXQEQueryNode createCategoryCount(INode category, XQENodeFactory nodeFactory) {
        IXQEQueryNode countNode = nodeFactory.createNode(2029);
        INode[] nodes = new INode[]{category};
        SelectionActionNodes selectionAction = (SelectionActionNodes)nodeFactory.createNode(22);
        selectionAction.setNodes(nodes);
        countNode.addChild((IXQEQueryNode)selectionAction);
        return countNode;
    }
}

